/*
 * Decompiled with CFR 0.152.
 */
package bluepot.pkgController;

import bluepot.pkgController.GraphUpdater;
import bluepot.pkgController.Randomiser;
import bluepot.pkgModel.Model;
import bluepot.pkgView.View;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.bluetooth.BluetoothStateException;

public class Controller {
    private View view;
    private Model model;
    private String[] localDeviceNameList;
    private int i;
    private GraphUpdater graphUpdater;
    private final Randomiser randomiser;

    public Controller(Model model, View view) {
        this.view = view;
        this.model = model;
        model.log(org.apache.log4j.Level.ALL, "Starting system..");
        view.setBtnSaveActionListener(new SaveSettingsActionListener());
        view.setBtnResetActionListener(new ResetActionListener());
        try {
            this.localDeviceNameList = model.getLocalDevicesName();
        }
        catch (BluetoothStateException ex) {
            Logger.getLogger(Controller.class.getName()).log(Level.SEVERE, null, ex);
        }
        this.graphUpdater = new GraphUpdater(view, model);
        this.randomiser = new Randomiser(model, view);
        new Thread(this.graphUpdater).start();
        new Thread(this.randomiser).start();
        model.startServers(view);
        model.addObserver(view);
    }

    public class ResetActionListener
    implements ActionListener {
        public void actionPerformed(ActionEvent ae) {
            Controller.this.model.resetTableData();
        }
    }

    public class SaveSettingsActionListener
    implements ActionListener {
        public void actionPerformed(ActionEvent ae) {
            Controller.this.model.applyTableData();
            Controller.this.view.updateSensors();
        }
    }
}

