/*
 * Decompiled with CFR 0.152.
 */
package bluepot.pkgModel;

import bluepot.pkgModel.AttackData.AttackData;
import bluepot.pkgModel.Config.Settings;
import bluepot.pkgModel.ConfigureSensors.SensorTableRow;
import bluepot.pkgModel.DeviceClass;
import bluepot.pkgModel.Sensor.Sensor;
import com.intel.bluetooth.BlueCoveImpl;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidClassException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Observable;
import java.util.Observer;
import java.util.Stack;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.bluetooth.BluetoothStateException;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.PatternLayout;

public class Model
extends Observable {
    private int noOfDevices = 0;
    private Sensor[] sensorArray;
    private SensorTableRow[] sensorTable;
    private org.apache.log4j.Logger logger;
    private DeviceClass deviceClass;
    private Settings settings;
    private HashMap<String, Stack> attackerList = new HashMap();
    private boolean newAttacker = false;

    public HashMap getAttackerList() {
        return this.attackerList;
    }

    public boolean getNewAttacker() {
        if (this.newAttacker) {
            this.newAttacker = false;
            return true;
        }
        return false;
    }

    public void addAttack(String attacker, String attack) {
        if (this.attackerList.get(attacker) == null) {
            Stack<String> tmp = new Stack<String>();
            tmp.push(Model.getDateTime() + " " + attack);
            this.attackerList.put(attacker, tmp);
            this.newAttacker = true;
        } else {
            Stack tmp = this.attackerList.get(attacker);
            tmp.push(Model.getDateTime() + " " + attack);
            this.attackerList.put(attacker, tmp);
        }
        this.setChanged();
        this.notifyObservers();
    }

    public Model() {
        this.deviceClass = new DeviceClass();
        try {
            this.startLogger();
        }
        catch (IOException ex) {
            Logger.getLogger(Model.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (ParseException ex) {
            Logger.getLogger(Model.class.getName()).log(Level.SEVERE, null, ex);
        }
        this.log(org.apache.log4j.Level.ALL, "Attempting to initialize bluetooth devices");
        this.initializeSensors();
        this.log(org.apache.log4j.Level.ALL, "Sensors initialized");
        this.loadTableData();
        this.log(org.apache.log4j.Level.ALL, "Loaded sensor configuration");
        if (this.loadConfiguration() != 1) {
            this.settings = new Settings();
        } else {
            this.log(org.apache.log4j.Level.ALL, "Loaded configuration");
        }
    }

    public Settings getSettings() {
        return this.settings;
    }

    public SensorTableRow getTableRow(int i) {
        return this.sensorTable[i];
    }

    public void setTableRow(int i, SensorTableRow str) {
        this.sensorTable[i] = str;
    }

    public int getNoOfDevices() {
        return this.noOfDevices;
    }

    public void setNoOfDevices(int i) {
        this.noOfDevices = i;
    }

    public String[] getMajorClassesList() {
        Object[] rtn = this.deviceClass.getMajorList();
        Arrays.sort(rtn);
        return rtn;
    }

    public String[] getMinorClassesList(String s) {
        Object[] rtn = this.deviceClass.getMinorList(s);
        Arrays.sort(rtn);
        return rtn;
    }

    public int getMajorClassInt(String s) {
        return this.deviceClass.getMajorInt(s);
    }

    public int getMinorClassInt(String s, String t) {
        return this.deviceClass.getMinorInt(s, t);
    }

    public String minorIntToString(int ma, int mi) {
        return this.deviceClass.minorIntToString(ma, mi);
    }

    public String majorIntToString(int ma) {
        return this.deviceClass.majorIntToString(ma);
    }

    public void startThreadedStack() {
        BlueCoveImpl.useThreadLocalBluetoothStack();
    }

    public Sensor getSensor(int i) {
        return this.sensorArray[i];
    }

    public static String discoverableIntToString(int discoverable) {
        if (discoverable == 10390323) {
            return "Full";
        }
        if (discoverable == 10390272) {
            return "Limited";
        }
        if (discoverable == 0) {
            return "Invisible";
        }
        if (discoverable == 1) {
            return "PREKNOWN";
        }
        if (discoverable == 0) {
            return "CACHED";
        }
        return "-1";
    }

    public static int discoverableStringToInt(String discoverable) {
        if (discoverable.equalsIgnoreCase("Full")) {
            return 10390323;
        }
        if (discoverable.equalsIgnoreCase("Limited")) {
            return 10390272;
        }
        if (discoverable.equalsIgnoreCase("Invisible")) {
            return 0;
        }
        if (discoverable.equalsIgnoreCase("PREKNOWN")) {
            return 1;
        }
        if (discoverable.equalsIgnoreCase("CACHED")) {
            return 0;
        }
        return -1;
    }

    public static String getDateTime() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
        Date date = new Date();
        return dateFormat.format(date);
    }

    public String[] getLocalDevicesName() throws BluetoothStateException {
        if (this.sensorArray.length > 0) {
            String[] rtn = new String[this.sensorArray.length];
            for (int i = 0; i < this.sensorArray.length; ++i) {
                rtn[i] = this.sensorArray[i].getLocalDeviceName();
            }
            return rtn;
        }
        return null;
    }

    public void setLocalDeviceName(int i, String s) throws IOException {
        this.sensorArray[i].setFriendlyDeviceName(s);
    }

    public void setLocalDeviceClass(int i, int major, int minor) throws IOException {
        this.sensorArray[i].setDeviceClass(major, minor);
    }

    public int getDeviceClassTotal(String major, String minor) {
        int a = this.deviceClass.getMinorInt(major, minor);
        int b = this.deviceClass.getMajorInt(major);
        return a + b;
    }

    public String logPath() throws IOException {
        File cwd = new File(".");
        SimpleDateFormat format = new SimpleDateFormat("yyyy/MMMMM/yyyyMMdd");
        Date now = new Date();
        String parsed = format.format(now);
        return cwd.getCanonicalPath() + "/logs/" + parsed + ".log";
    }

    public String logFolder() throws IOException {
        File cwd = new File(".");
        SimpleDateFormat format = new SimpleDateFormat("yyyy/MMMMM/");
        Date now = new Date();
        String parsed = format.format(now);
        return cwd.getCanonicalPath() + "/logs/" + parsed;
    }

    public void startLogger() throws IOException, ParseException {
        this.logger = org.apache.log4j.Logger.getLogger("Bluepot");
        File logFolder = new File(this.logFolder());
        if (!logFolder.exists()) {
            logFolder.mkdirs();
        }
        String pattern = "%d{ISO8601} - %C - %m %n";
        PatternLayout pl = new PatternLayout(pattern);
        FileAppender fa = new FileAppender((Layout)pl, this.logPath());
        this.logger.addAppender(fa);
        this.logger.setLevel(org.apache.log4j.Level.ALL);
    }

    public void log(org.apache.log4j.Level level, String msg) {
        this.logger.log(level, msg);
        System.out.println(level.toString() + ":" + msg);
    }

    public void initializeSensors() {
        BlueCoveImpl.setConfigProperty((String)"bluecove.deviceID", (String)"0");
        Vector localDeviceList = null;
        try {
            localDeviceList = BlueCoveImpl.getLocalDevicesID();
        }
        catch (BluetoothStateException ex) {
            this.log(org.apache.log4j.Level.FATAL, "Bluetooth State Exception when getting list of local devices");
            this.log(org.apache.log4j.Level.FATAL, ex.toString());
            this.log(org.apache.log4j.Level.FATAL, "System exiting");
            BlueCoveImpl.shutdown();
            System.out.println("boo3");
            System.exit(1);
        }
        this.noOfDevices = localDeviceList.size();
        this.sensorArray = new Sensor[this.noOfDevices];
        this.sensorTable = new SensorTableRow[this.noOfDevices];
        for (int i = 0; i < this.noOfDevices; ++i) {
            if (i == 0) {
                try {
                    Object id = BlueCoveImpl.getThreadBluetoothStackID();
                    this.sensorArray[i] = new Sensor(id, (String)localDeviceList.get(i), this);
                }
                catch (BluetoothStateException ex) {
                    this.log(org.apache.log4j.Level.FATAL, "Bluetooth State Exception when starting a device manager");
                    this.log(org.apache.log4j.Level.FATAL, ex.toString());
                    this.log(org.apache.log4j.Level.FATAL, "System exiting");
                    BlueCoveImpl.shutdown();
                    System.out.println("boo4");
                    System.exit(1);
                }
            } else {
                try {
                    this.sensorArray[i] = new Sensor(i, (String)localDeviceList.get(i), this);
                }
                catch (BluetoothStateException ex) {
                    this.log(org.apache.log4j.Level.FATAL, "Bluetooth State Exception when starting a device manager");
                    this.log(org.apache.log4j.Level.FATAL, ex.toString());
                    this.log(org.apache.log4j.Level.FATAL, "System exiting");
                    BlueCoveImpl.shutdown();
                    System.out.println("boo5");
                    System.exit(1);
                }
                catch (Exception ex) {
                    this.log(org.apache.log4j.Level.FATAL, "Something else bad happened");
                    BlueCoveImpl.shutdown();
                    System.out.println("boo6");
                    System.exit(1);
                }
            }
            new Thread(this.sensorArray[i]).start();
            while (!this.sensorArray[i].isRunning()) {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException ex) {
                    Logger.getLogger(Model.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
    }

    public void startServers(Observer view) {
        for (int i = 0; i < this.getNoOfDevices(); ++i) {
            this.sensorArray[i].startListeners(view);
        }
    }

    public void updateTableRow(int id) {
        this.sensorTable[id] = new SensorTableRow(this.sensorArray[id]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int loadConfiguration() {
        File config = new File("data/config.ser");
        if (config.exists()) {
            FileInputStream file = null;
            try {
                file = new FileInputStream("data/config.ser");
                BufferedInputStream buffer = new BufferedInputStream(file);
                ObjectInputStream input = new ObjectInputStream(buffer);
                this.settings = (Settings)input.readObject();
                return (int)this.settings;
            }
            catch (InvalidClassException ex) {
                config.delete();
            }
            catch (ClassNotFoundException ex) {
                Logger.getLogger(Model.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (IOException ex) {
                Logger.getLogger(Model.class.getName()).log(Level.SEVERE, null, ex);
            }
            finally {
                return 1;
            }
        }
        return -1;
    }

    public void loadTableData() {
        for (int j = 0; j < this.noOfDevices; ++j) {
            File test = new File("data/hci" + j + ".ser");
            if (test.exists()) {
                FileInputStream file = null;
                try {
                    file = new FileInputStream("data/hci" + j + ".ser");
                    BufferedInputStream buffer = new BufferedInputStream(file);
                    ObjectInputStream input = new ObjectInputStream(buffer);
                    SensorTableRow str = (SensorTableRow)input.readObject();
                    ((InputStream)file).close();
                    this.sensorTable[j] = str;
                    this.sensorArray[j].applySettings(this.sensorTable[j]);
                }
                catch (ClassNotFoundException ex) {
                    Logger.getLogger(Model.class.getName()).log(Level.SEVERE, null, ex);
                }
                catch (IOException ex) {
                    Logger.getLogger(Model.class.getName()).log(Level.SEVERE, null, ex);
                }
                continue;
            }
            this.sensorTable[j] = new SensorTableRow(this.sensorArray[j]);
        }
    }

    public void resetTableData() {
        for (int j = 0; j < this.noOfDevices; ++j) {
            this.sensorTable[j] = new SensorTableRow(this.sensorArray[j]);
        }
    }

    public void saveConfiguration() {
        try {
            FileOutputStream file = null;
            ObjectOutputStream output = null;
            try {
                file = new FileOutputStream("data/config.ser");
            }
            catch (FileNotFoundException ex) {
                Logger.getLogger(Model.class.getName()).log(Level.SEVERE, null, ex);
            }
            BufferedOutputStream buffer = new BufferedOutputStream(file);
            output = new ObjectOutputStream(buffer);
            output.writeObject(this.settings);
            output.close();
        }
        catch (IOException ex) {
            Logger.getLogger(Model.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void applyTableData() {
        for (int j = 0; j < this.noOfDevices; ++j) {
            try {
                FileOutputStream file = null;
                ObjectOutputStream output = null;
                try {
                    file = new FileOutputStream("data/hci" + j + ".ser");
                }
                catch (FileNotFoundException ex) {
                    Logger.getLogger(Model.class.getName()).log(Level.SEVERE, null, ex);
                }
                BufferedOutputStream buffer = new BufferedOutputStream(file);
                output = new ObjectOutputStream(buffer);
                this.sensorArray[j].updateSettings(this.sensorTable[j]);
                output.writeObject(this.sensorTable[j]);
                output.close();
                continue;
            }
            catch (IOException ex) {
                Logger.getLogger(Model.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    public AttackData readAttackData(int j) {
        return this.sensorArray[j].getAttackData();
    }
}

