/*
 * Decompiled with CFR 0.152.
 */
package bluepot.pkgModel.Modules;

import bluepot.pkgController.EmailFile;
import bluepot.pkgModel.AttackData.AttackConnect;
import bluepot.pkgModel.AttackData.AttackModule;
import bluepot.pkgModel.AttackData.OBEX.AttackFileRcvd;
import bluepot.pkgModel.AttackData.OBEX.AttackOBEXFile;
import bluepot.pkgModel.Model;
import bluepot.pkgModel.Modules.L2CAPServer;
import bluepot.pkgModel.ObserverMessage;
import com.intel.bluetooth.BlueCoveImpl;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Observable;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.bluetooth.BluetoothStateException;
import javax.bluetooth.DataElement;
import javax.bluetooth.LocalDevice;
import javax.bluetooth.RemoteDevice;
import javax.bluetooth.ServiceRecord;
import javax.bluetooth.ServiceRegistrationException;
import javax.bluetooth.UUID;
import javax.microedition.io.Connection;
import javax.microedition.io.Connector;
import javax.obex.HeaderSet;
import javax.obex.Operation;
import javax.obex.ServerRequestHandler;
import javax.obex.SessionNotifier;

public class OBEXServer
extends Observable
implements Runnable {
    private SessionNotifier serverConnection;
    public static final String SERVER_NAME = "OBEX Object Push";
    final UUID OBEX_OBJECT_PUSH = new UUID(4357L);
    boolean isRunning = false;
    boolean isStopped = false;
    int id;
    private Object dongleID;
    LocalDevice localDevice;
    AttackModule attackModule;
    Calendar cal;
    Model model;
    private boolean running = false;

    public boolean isRunning() {
        return this.running;
    }

    private Connection keepOpeningConnection(String url) {
        Connection connection;
        try {
            connection = Connector.open((String)url);
        }
        catch (ServiceRegistrationException ex) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException ex1) {
                Logger.getLogger(L2CAPServer.class.getName()).log(Level.SEVERE, null, ex1);
            }
            connection = this.keepOpeningConnection(url);
        }
        catch (IOException ex) {
            System.out.println("serious error");
            return null;
        }
        return connection;
    }

    private void keepUpdatingSDP(ServiceRecord record) {
        try {
            this.localDevice.updateRecord(record);
        }
        catch (ServiceRegistrationException ex) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException ex1) {
                Logger.getLogger(OBEXServer.class.getName()).log(Level.SEVERE, null, ex1);
            }
            this.keepUpdatingSDP(record);
        }
    }

    public OBEXServer(Model model, int id, Object dongleID, AttackModule attackModule) {
        this.dongleID = dongleID;
        this.id = id;
        this.attackModule = attackModule;
        this.model = model;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        BlueCoveImpl.useThreadLocalBluetoothStack();
        BlueCoveImpl.setThreadBluetoothStackID((Object)this.dongleID);
        try {
            this.localDevice = LocalDevice.getLocalDevice();
        }
        catch (BluetoothStateException ex) {
            // empty catch block
        }
        this.setChanged();
        this.notifyObservers(new ObserverMessage(this.id, "[OBEX] Server starting.."));
        this.isStopped = false;
        String connectorUrl = "btgoep://localhost:" + this.OBEX_OBJECT_PUSH + ";name=" + SERVER_NAME;
        this.serverConnection = (SessionNotifier)this.keepOpeningConnection(connectorUrl);
        this.setChanged();
        this.notifyObservers(new ObserverMessage(this.id, "[OBEX] Server started"));
        this.running = true;
        try {
            ServiceRecord record = this.localDevice.getRecord((Connection)this.serverConnection);
            String url = record.getConnectionURL(0, false);
            DataElement bluetoothProfileDescriptorList = new DataElement(48);
            DataElement obbexPushProfileDescriptor = new DataElement(48);
            obbexPushProfileDescriptor.addElement(new DataElement(24, (Object)this.OBEX_OBJECT_PUSH));
            obbexPushProfileDescriptor.addElement(new DataElement(9, 256L));
            bluetoothProfileDescriptorList.addElement(obbexPushProfileDescriptor);
            record.setAttributeValue(9, bluetoothProfileDescriptorList);
            int ATTR_SUPPORTED_FORMAT_LIST_LIST = 771;
            DataElement supportedFormatList = new DataElement(48);
            supportedFormatList.addElement(new DataElement(8, 255L));
            record.setAttributeValue(771, supportedFormatList);
            int UUID_PUBLICBROWSE_GROUP = 4098;
            int ATTR_BROWSE_GRP_LIST = 5;
            DataElement browseClassIDList = new DataElement(48);
            UUID browseClassUUID = new UUID(4098L);
            browseClassIDList.addElement(new DataElement(24, (Object)browseClassUUID));
            record.setAttributeValue(5, browseClassIDList);
            this.keepUpdatingSDP(record);
        }
        catch (Throwable e) {
            this.setChanged();
        }
        try {
            int errorCount = 0;
            int count = 0;
            this.isRunning = true;
            while (!this.isStopped) {
                RequestHandler handler = new RequestHandler();
                try {
                    ++count;
                    Connection c = this.serverConnection.acceptAndOpen((ServerRequestHandler)handler);
                    handler.connectionAccepted(c);
                }
                catch (InterruptedIOException e) {
                    this.isStopped = true;
                    break;
                }
                catch (Throwable e) {
                    if ("Stack closed".equals(e.getMessage())) {
                        this.isStopped = true;
                    }
                    if (this.isStopped) {
                        this.setChanged();
                        this.notifyObservers(new ObserverMessage(this.id, "OBEX Server finished!"));
                        this.isRunning = false;
                        return;
                    }
                    ++errorCount;
                    continue;
                }
                errorCount = 0;
            }
        }
        finally {
            this.setChanged();
            this.notifyObservers(new ObserverMessage(this.id, "OBEX Server finished!"));
            this.isRunning = false;
        }
    }

    private class RequestHandler
    extends ServerRequestHandler {
        Timer notConnectedTimer = new Timer();
        boolean isConnected = false;
        boolean receivedOk = false;
        Connection cconn;

        private RequestHandler() {
        }

        void connectionAccepted(Connection cconn) throws IOException {
            OBEXServer.this.setChanged();
            OBEXServer.this.notifyObservers(new ObserverMessage(OBEXServer.this.id, "[OBEX] Received connection from " + RemoteDevice.getRemoteDevice((Connection)cconn)));
            this.cconn = cconn;
            if (!this.isConnected) {
                this.notConnectedTimer.schedule(new TimerTask(){

                    public void run() {
                        RequestHandler.this.notConnectedClose();
                    }
                }, 30000L);
            }
        }

        void notConnectedClose() {
            if (!this.isConnected) {
                OBEXServer.this.setChanged();
                OBEXServer.this.notifyObservers(new ObserverMessage(OBEXServer.this.id, "[OBEX] Connection timed out"));
                try {
                    this.cconn.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (!this.receivedOk) {
                    // empty if block
                }
            }
        }

        public int onConnect(HeaderSet request, HeaderSet reply) {
            this.isConnected = true;
            this.notConnectedTimer.cancel();
            OBEXServer.this.setChanged();
            try {
                OBEXServer.this.notifyObservers(new ObserverMessage(OBEXServer.this.id, "[OBEX] Got connection from " + RemoteDevice.getRemoteDevice((Connection)this.cconn)));
                OBEXServer.this.attackModule.addTo("connect", new AttackConnect(Calendar.getInstance().getTime(), RemoteDevice.getRemoteDevice((Connection)this.cconn).toString()));
                OBEXServer.this.model.addAttack(RemoteDevice.getRemoteDevice((Connection)this.cconn).toString(), "[Device " + OBEXServer.this.id + "] Connected to OBEX");
            }
            catch (IOException ex) {
                Logger.getLogger(OBEXServer.class.getName()).log(Level.SEVERE, null, ex);
            }
            return 160;
        }

        public void onDisconnect(HeaderSet request, HeaderSet reply) {
            OBEXServer.this.setChanged();
            try {
                OBEXServer.this.notifyObservers(new ObserverMessage(OBEXServer.this.id, "[OBEX] Got disconnection from " + RemoteDevice.getRemoteDevice((Connection)this.cconn)));
                OBEXServer.this.model.addAttack(RemoteDevice.getRemoteDevice((Connection)this.cconn).toString(), "[Device " + OBEXServer.this.id + "] Disconnected from OBEX");
            }
            catch (IOException ex) {
                Logger.getLogger(OBEXServer.class.getName()).log(Level.SEVERE, null, ex);
            }
            if (!this.receivedOk) {
                // empty if block
            }
        }

        public int onSetPath(HeaderSet request, HeaderSet reply, boolean backup, boolean create) {
            OBEXServer.this.setChanged();
            try {
                String name = (String)request.getHeader(1);
                OBEXServer.this.setChanged();
                OBEXServer.this.notifyObservers(new ObserverMessage(OBEXServer.this.id, "[OBEX] Got set path - " + name));
                OBEXServer.this.attackModule.addTo("delete", new AttackOBEXFile(Calendar.getInstance().getTime(), name, RemoteDevice.getRemoteDevice((Connection)this.cconn).toString()));
                OBEXServer.this.setChanged();
                OBEXServer.this.notifyObservers(new ObserverMessage(OBEXServer.this.id, "[OBEX] onDelete"));
            }
            catch (IOException ex) {
                Logger.getLogger(OBEXServer.class.getName()).log(Level.SEVERE, null, ex);
            }
            OBEXServer.this.notifyObservers(new ObserverMessage(OBEXServer.this.id, "OBEX onSetPath"));
            return super.onSetPath(request, reply, backup, create);
        }

        public int onDelete(HeaderSet request, HeaderSet reply) {
            try {
                String name = (String)request.getHeader(1);
                OBEXServer.this.setChanged();
                OBEXServer.this.notifyObservers(new ObserverMessage(OBEXServer.this.id, "OBEX onGet"));
                OBEXServer.this.attackModule.addTo("delete", new AttackOBEXFile(Calendar.getInstance().getTime(), name, RemoteDevice.getRemoteDevice((Connection)this.cconn).toString()));
                OBEXServer.this.setChanged();
                OBEXServer.this.notifyObservers(new ObserverMessage(OBEXServer.this.id, "OBEX onDelete"));
            }
            catch (IOException ex) {
                Logger.getLogger(OBEXServer.class.getName()).log(Level.SEVERE, null, ex);
            }
            return super.onDelete(request, reply);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int onPut(Operation op) {
            OBEXServer.this.setChanged();
            OBEXServer.this.notifyObservers(new ObserverMessage(OBEXServer.this.id, "[OBEX] Attacker initiated file send"));
            try {
                OBEXServer.this.model.addAttack(RemoteDevice.getRemoteDevice((Connection)this.cconn).toString(), "[Device " + OBEXServer.this.id + "] Initiated file send");
            }
            catch (IOException ex) {
                Logger.getLogger(OBEXServer.class.getName()).log(Level.SEVERE, null, ex);
            }
            try {
                HeaderSet hs = op.getReceivedHeaders();
                String name = (String)hs.getHeader(1);
                if (name == null) {
                    long milli = Calendar.getInstance().getTimeInMillis();
                    name = "unnamed_" + Long.toString(milli);
                }
                Long len = (Long)hs.getHeader(195);
                if (len != null) {
                    // empty if block
                }
                SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd");
                Date now = new Date();
                String parsed = format.format(now);
                String storageFolder = OBEXServer.this.model.getSettings().getSaveFolder();
                String saveFolder = storageFolder + "/" + parsed;
                File save = new File(saveFolder);
                if (!save.exists()) {
                    save.mkdirs();
                }
                if (save.getFreeSpace() < 0x3200000L) {
                    System.err.println("Error: Not Writing File. Less than 50mb Free Space");
                } else {
                    int data;
                    String saveName = name + "_" + Calendar.getInstance().getTimeInMillis() + ".virus";
                    File f = new File(saveFolder, name);
                    FileOutputStream out = new FileOutputStream(f);
                    InputStream is = op.openInputStream();
                    int received = 0;
                    while (!OBEXServer.this.isStopped && (data = is.read()) != -1) {
                        out.write(data);
                        if (len != null && ++received % 100 != 0) continue;
                    }
                    op.close();
                    this.receivedOk = true;
                    OBEXServer.this.setChanged();
                    OBEXServer.this.notifyObservers(new ObserverMessage(OBEXServer.this.id, "[OBEX] File recieved"));
                    try {
                        OBEXServer.this.model.addAttack(RemoteDevice.getRemoteDevice((Connection)this.cconn).toString(), "[Device " + OBEXServer.this.id + "] Finished sending file");
                    }
                    catch (IOException ex) {
                        Logger.getLogger(OBEXServer.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    OBEXServer.this.attackModule.addTo("filercvd", new AttackFileRcvd(Calendar.getInstance().getTime(), name, len, RemoteDevice.getRemoteDevice((Connection)this.cconn).toString()));
                    if (OBEXServer.this.model.getSettings().isEmailEnabled()) {
                        EmailFile ef = new EmailFile();
                        ef.sendEmail(saveFolder + "/" + name, OBEXServer.this.model.getSettings());
                        OBEXServer.this.setChanged();
                        OBEXServer.this.notifyObservers(new ObserverMessage(OBEXServer.this.id, "[OBEX] File e-mailed to " + OBEXServer.this.model.getSettings().getEmailTo()));
                    }
                }
                int n = 160;
                return n;
            }
            catch (IOException e) {
                int n = 211;
                return n;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int onGet(Operation op) {
            try {
                HeaderSet hs = op.getReceivedHeaders();
                String name = (String)hs.getHeader(1);
                OBEXServer.this.setChanged();
                OBEXServer.this.notifyObservers(new ObserverMessage(OBEXServer.this.id, "[OBEX] Attacker requested file: " + name));
                OBEXServer.this.attackModule.addTo("get", new AttackOBEXFile(Calendar.getInstance().getTime(), name, RemoteDevice.getRemoteDevice((Connection)this.cconn).toString()));
                OBEXServer.this.model.addAttack(RemoteDevice.getRemoteDevice((Connection)this.cconn).toString(), "[Device " + OBEXServer.this.id + "] Requested file: " + name);
                DataOutputStream output = op.openDataOutputStream();
                output.write(OBEXServer.this.model.getSettings().getRespOBEXGet().getBytes());
                output.close();
                int n = 160;
                return n;
            }
            catch (IOException e) {
                int n = 211;
                return n;
            }
        }

        public void onAuthenticationFailure(byte[] userName) {
        }
    }
}

