/*
 * Decompiled with CFR 0.152.
 */
package bluepot.pkgView.Sensors.Overview;

import bluepot.pkgModel.ConfigureSensors.SensorTableRow;
import bluepot.pkgModel.Model;
import bluepot.pkgView.View;
import javax.swing.JComboBox;
import javax.swing.table.AbstractTableModel;

public class DevicesTableModel
extends AbstractTableModel {
    Model model;
    View view;
    public static final int ID = 0;
    public static final int NAME = 1;
    public static final int VISIBLE = 2;
    public static final int MAJOR = 3;
    public static final int MINOR = 4;
    public static final int OBEX = 5;
    public static final int RFCOMM = 6;
    public static final int L2CAP = 7;
    public static final int LOCKED = 8;

    public DevicesTableModel(Model model, View view) {
        this.model = model;
        this.view = view;
    }

    public int getRowCount() {
        return this.model.getNoOfDevices();
    }

    public int getColumnCount() {
        return 9;
    }

    public Class getColumnClass(int columnIndex) {
        if (columnIndex == 8) {
            return Boolean.class;
        }
        if (columnIndex == 5) {
            return Boolean.class;
        }
        if (columnIndex == 6) {
            return Boolean.class;
        }
        if (columnIndex == 7) {
            return Boolean.class;
        }
        if (columnIndex == 3) {
            return JComboBox.class;
        }
        if (columnIndex == 4) {
            return JComboBox.class;
        }
        if (columnIndex == 2) {
            return JComboBox.class;
        }
        return String.class;
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        Object rtn = null;
        switch (columnIndex) {
            case 0: {
                rtn = this.model.getTableRow(rowIndex).getId();
                break;
            }
            case 1: {
                rtn = this.model.getTableRow(rowIndex).getFriendlyName();
                break;
            }
            case 2: {
                rtn = Model.discoverableIntToString(this.model.getTableRow(rowIndex).getDiscoverable());
                break;
            }
            case 8: {
                rtn = this.model.getTableRow(rowIndex).isLocked();
                break;
            }
            case 3: {
                rtn = this.model.majorIntToString(this.model.getTableRow(rowIndex).getMajor());
                break;
            }
            case 4: {
                rtn = this.model.minorIntToString(this.model.getTableRow(rowIndex).getMajor(), this.model.getTableRow(rowIndex).getMinor());
                break;
            }
            case 5: {
                rtn = this.model.getTableRow(rowIndex).isOBEX();
                break;
            }
            case 7: {
                rtn = this.model.getTableRow(rowIndex).isL2CAP();
                break;
            }
            case 6: {
                rtn = this.model.getTableRow(rowIndex).isRFCOMM();
                break;
            }
            default: {
                rtn = "";
            }
        }
        return rtn;
    }

    public boolean isCellEditable(int rowIndex, int columnIndex) {
        switch (columnIndex) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return true;
            }
        }
        return false;
    }

    public void setValueAt(Object value, int rowIndex, int columnIndex) {
        if (columnIndex == 8) {
            SensorTableRow tmp = this.model.getTableRow(rowIndex);
            tmp.setLocked(new Boolean(value.toString()));
            this.model.setTableRow(rowIndex, tmp);
            this.fireTableCellUpdated(rowIndex, columnIndex);
        } else if (columnIndex == 5) {
            SensorTableRow tmp = this.model.getTableRow(rowIndex);
            tmp.setOBEX(new Boolean(value.toString()));
            this.model.setTableRow(rowIndex, tmp);
            this.fireTableCellUpdated(rowIndex, columnIndex);
        } else if (columnIndex == 6) {
            SensorTableRow tmp = this.model.getTableRow(rowIndex);
            tmp.setRFCOMM(new Boolean(value.toString()));
            this.model.setTableRow(rowIndex, tmp);
            this.fireTableCellUpdated(rowIndex, columnIndex);
        } else if (columnIndex == 7) {
            SensorTableRow tmp = this.model.getTableRow(rowIndex);
            tmp.setL2CAP(new Boolean(value.toString()));
            this.model.setTableRow(rowIndex, tmp);
            this.fireTableCellUpdated(rowIndex, columnIndex);
        } else if (columnIndex == 1) {
            SensorTableRow tmp = this.model.getTableRow(rowIndex);
            tmp.setFriendlyName(String.valueOf(value));
            this.model.setTableRow(rowIndex, tmp);
            this.fireTableCellUpdated(rowIndex, columnIndex);
        } else if (columnIndex == 3) {
            SensorTableRow tmp = this.model.getTableRow(rowIndex);
            int major = this.model.getMajorClassInt(String.valueOf(value));
            tmp.setMajor(major);
            tmp.setMinor(0);
            this.fireTableRowsUpdated(rowIndex, rowIndex);
        } else if (columnIndex == 4) {
            SensorTableRow tmp = this.model.getTableRow(rowIndex);
            int majorInt = this.model.getTableRow(rowIndex).getMajor();
            String majorString = this.model.majorIntToString(majorInt);
            String minorString = String.valueOf(value);
            int minorInt = this.model.getMinorClassInt(majorString, minorString);
            tmp.setMinor(minorInt);
            this.fireTableCellUpdated(rowIndex, columnIndex);
        } else if (columnIndex == 2) {
            SensorTableRow tmp = this.model.getTableRow(rowIndex);
            int visible = Model.discoverableStringToInt(String.valueOf(value));
            tmp.setDiscoverable(visible);
        }
    }

    public String getColumnName(int i) {
        String columnName = "";
        switch (i) {
            case 1: {
                columnName = "Name";
                break;
            }
            case 2: {
                columnName = "Visibility";
                break;
            }
            case 3: {
                columnName = "Major";
                break;
            }
            case 4: {
                columnName = "Minor";
                break;
            }
            case 5: {
                columnName = "OBEX";
                break;
            }
            case 7: {
                columnName = "L2CAP";
                break;
            }
            case 6: {
                columnName = "RFCOMM";
                break;
            }
            case 8: {
                columnName = "Lock";
                break;
            }
            default: {
                columnName = "";
            }
        }
        return columnName;
    }
}

