/*
 * Decompiled with CFR 0.152.
 */
package bluepot.pkgView.Sensors.Overview;

import bluepot.pkgModel.Model;
import bluepot.pkgView.Sensors.Overview.SmallDevicesTableModel;
import bluepot.pkgView.StatFactory.GraphFactory;
import bluepot.pkgView.StatFactory.GraphOverall;
import bluepot.pkgView.StatFactory.GraphSensors;
import bluepot.pkgView.StatFactory.ListManager;
import bluepot.pkgView.StatFactory.ListManagerOBEX;
import bluepot.pkgView.View;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import net.miginfocom.swing.MigLayout;
import org.jdesktop.swingx.JXTitledPanel;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;

public class OverviewStatus
extends JPanel {
    int sensorId;
    View view;
    Model model;
    private final GraphFactory obexFilesRecievedGraph;
    private final ChartPanel panel1;
    private final ChartPanel panel2;
    private final SmallDevicesTableModel tableModel;
    private final ListManagerOBEX obexFilesRecievedListManager;
    private final ListManager allListManager;
    private final GraphOverall overallGraph;
    private final ChartPanel panel4;
    private final JLabel last10Attackers;
    private final JLabel top10Attackers;
    private final JLabel last10Files;
    private JLabel txtSensorsOnline;
    private JLabel txtConnsRcvd;
    private JLabel txtUniqueAttackers;
    private JLabel txtFilesRcvd;
    private JLabel txtRandomiserEnabled;
    private ImageIcon icnTick = new ImageIcon("icons/tick.png");
    private ImageIcon icnAttacker = new ImageIcon("icons/user.png");
    private ImageIcon icnConn = new ImageIcon("icons/bug.png");
    private ImageIcon icnFiles = new ImageIcon("icons/folder.png");
    private ImageIcon icnRandom = new ImageIcon("icons/time.png");
    private final ListManager sensorsOverallManager;
    private final GraphSensors sensorsOverallGraph;

    public OverviewStatus(int sensorId, View view, Model model) {
        super(new MigLayout("wrap 2"));
        this.sensorId = sensorId;
        this.view = view;
        this.model = model;
        Font headerFont = new Font("Arial", 1, 14);
        JPanel mainStatus = new JPanel(new MigLayout("", "[][]150[][]"));
        JXTitledPanel mainStatusWithTitle = new JXTitledPanel("System Overview", (Container)mainStatus);
        Font txtFont = new Font("Arial", 1, 12);
        JLabel sensorsOnline = new JLabel("Sensors Online:", this.icnTick, 2);
        this.txtSensorsOnline = new JLabel();
        this.txtSensorsOnline.setText(Integer.toString(model.getNoOfDevices()));
        this.txtSensorsOnline.setFont(txtFont);
        JLabel connectionsRcvd = new JLabel("Connections Rcvd:", this.icnConn, 2);
        this.txtConnsRcvd = new JLabel("0");
        this.txtConnsRcvd.setFont(txtFont);
        JLabel uniqueAttackers = new JLabel("Unique Attackers:", this.icnAttacker, 10);
        this.txtUniqueAttackers = new JLabel("0");
        this.txtUniqueAttackers.setFont(txtFont);
        JLabel filesRcvd = new JLabel("Files Recieved", this.icnFiles, 2);
        this.txtFilesRcvd = new JLabel("0");
        this.txtFilesRcvd.setFont(txtFont);
        JLabel randomiserEnabled = new JLabel("Randomiser Enabled:", this.icnRandom, 2);
        this.txtRandomiserEnabled = new JLabel("True");
        this.txtRandomiserEnabled.setFont(txtFont);
        mainStatus.add((Component)sensorsOnline, "cell 0 0");
        mainStatus.add((Component)this.txtSensorsOnline, "cell 1 0");
        mainStatus.add((Component)connectionsRcvd, "cell 0 1");
        mainStatus.add((Component)this.txtConnsRcvd, "cell 1 1");
        mainStatus.add((Component)uniqueAttackers, "cell 0 2");
        mainStatus.add((Component)this.txtUniqueAttackers, "cell 1 2");
        mainStatus.add((Component)filesRcvd, "cell 0 3");
        mainStatus.add((Component)this.txtFilesRcvd, "cell 1 3");
        mainStatus.add((Component)randomiserEnabled, "cell 0 4");
        mainStatus.add((Component)this.txtRandomiserEnabled, "cell 1 4");
        JPanel deviceListPnl = new JPanel(new MigLayout("wrap 1"));
        JXTitledPanel deviceListPnlWithTitle = new JXTitledPanel("Available Devices", (Container)deviceListPnl);
        this.tableModel = new SmallDevicesTableModel(model, view);
        JTable smallDevicesTable = new JTable(this.tableModel);
        smallDevicesTable.setAutoResizeMode(4);
        smallDevicesTable.getColumnModel().getColumn(0).setPreferredWidth(20);
        smallDevicesTable.getColumnModel().getColumn(0).setMaxWidth(20);
        smallDevicesTable.getColumnModel().getColumn(1).setPreferredWidth(150);
        smallDevicesTable.getColumnModel().getColumn(2).setPreferredWidth(200);
        smallDevicesTable.setColumnSelectionAllowed(false);
        smallDevicesTable.setRowSelectionAllowed(false);
        smallDevicesTable.setCellSelectionEnabled(false);
        JScrollPane smallJViewport = new JScrollPane(smallDevicesTable);
        smallDevicesTable.setFillsViewportHeight(true);
        deviceListPnlWithTitle.add((Component)smallJViewport);
        JXTitledPanel graphsWithTitle = new JXTitledPanel("Graphs");
        JPanel graphs = new JPanel(new MigLayout("wrap 2"));
        this.obexFilesRecievedListManager = new ListManagerOBEX();
        this.allListManager = new ListManager();
        this.sensorsOverallManager = new ListManager();
        this.sensorsOverallGraph = new GraphSensors(model, this.sensorsOverallManager);
        this.overallGraph = new GraphOverall(model, this.allListManager);
        this.obexFilesRecievedGraph = new GraphFactory(model, -1, "obexpush", "filercvd", "Files Recieved", "Time", "No. Of Files", GraphFactory.TYPE_BAR, this.obexFilesRecievedListManager);
        JFreeChart overallChart = this.overallGraph.getChart();
        JFreeChart obexFRG = this.obexFilesRecievedGraph.getChart();
        JFreeChart sensorsChart = this.sensorsOverallGraph.getChart();
        this.panel1 = new ChartPanel(obexFRG);
        this.panel1.setInitialDelay(0);
        this.panel2 = new ChartPanel(sensorsChart);
        this.panel2.setInitialDelay(0);
        this.panel4 = new ChartPanel(overallChart);
        JPanel listsPanel = new JPanel(new MigLayout("wrap 3", "[center][center][center]", "[center][center][center]"));
        JPanel last10Panel = new JPanel(new MigLayout("wrap 1"));
        JPanel top10Panel = new JPanel(new MigLayout("wrap 1"));
        JPanel lastFilesPanel = new JPanel(new MigLayout("wrap 1"));
        JLabel last10 = new JLabel("<html><strong><h2>Last 10 Attackers</h2></strong></html>");
        JLabel top10 = new JLabel("<html><strong><h2>Top 10 Attackers</h2></strong></html>");
        JLabel lastFiles = new JLabel("<html><strong><h2>Last 10 Files</h2></strong></html>");
        this.last10Attackers = new JLabel("<html><ol><li></li><li>-</li><li>-</li><li>-</li><li>-</li><li>-</li><li>-</li><li>-</li><li>-</li><li>-</li></ol></html>");
        this.top10Attackers = new JLabel("<html><ol><li>-</li><li>-</li><li>-</li><li>-</li><li>-</li><li>-</li><li>-</li><li>-</li><li>-</li><li>-</li></ol></html>");
        this.last10Files = new JLabel("<html><ol><li>-</li><li>-</li><li>-</li><li>-</li><li>-</li><li>-</li><li>-</li><li>-</li><li>-</li><li>-</li></ol></html>");
        last10Panel.add(last10);
        last10Panel.add((Component)this.last10Attackers, "align left");
        top10Panel.add(top10);
        top10Panel.add((Component)this.top10Attackers, "align left");
        lastFilesPanel.add(lastFiles);
        lastFilesPanel.add((Component)this.last10Files, "align left");
        listsPanel.add((Component)last10Panel, "w 33%");
        listsPanel.add((Component)top10Panel, "w 33%");
        listsPanel.add((Component)lastFilesPanel, "w 33%");
        graphs.add((Component)this.panel4);
        graphs.add((Component)listsPanel, "w 50%, h 33%");
        graphs.add((Component)this.panel1);
        graphs.add((Component)this.panel2);
        graphsWithTitle.add((Component)graphs);
        this.add((Component)mainStatusWithTitle, "width 50%, growy");
        this.add((Component)deviceListPnlWithTitle, "width 50%");
        this.add((Component)graphsWithTitle, "w 100%, span 2");
    }

    public void updateSmallTable() {
        this.tableModel.fireTableDataChanged();
    }

    public void updateCharts() {
        this.obexFilesRecievedGraph.updateData();
        this.overallGraph.updateData();
        this.sensorsOverallGraph.updateData();
        this.last10Attackers.setText(this.allListManager.getRecentAttackers(10));
        this.top10Attackers.setText(this.allListManager.getTopVolumeAttackers(10));
        this.last10Files.setText(this.obexFilesRecievedListManager.getRecentFiles(10));
        this.txtFilesRcvd.setText(Integer.toString(this.obexFilesRecievedListManager.getNoOfFiles()));
        this.txtConnsRcvd.setText(Integer.toString(this.allListManager.getNoOfAttacks()));
        this.txtUniqueAttackers.setText(Integer.toString(this.allListManager.getNoOfAttackers()));
        if (this.model.getSettings().isRandomEnabled()) {
            this.txtRandomiserEnabled.setText("True");
        } else {
            this.txtRandomiserEnabled.setText("False");
        }
    }
}

