/*
 * Decompiled with CFR 0.152.
 */
package bluepot.pkgView.Sensors.Overview;

import bluepot.pkgModel.Model;
import bluepot.pkgView.View;
import javax.swing.table.AbstractTableModel;

public class SmallDevicesTableModel
extends AbstractTableModel {
    Model model;
    View view;
    public static final int ID = 0;
    public static final int NAME = 1;
    public static final int TYPE = 2;

    public SmallDevicesTableModel(Model model, View view) {
        this.model = model;
        this.view = view;
    }

    public int getRowCount() {
        return this.model.getNoOfDevices();
    }

    public int getColumnCount() {
        return 3;
    }

    public Class getColumnClass(int columnIndex) {
        return String.class;
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        Object rtn = null;
        switch (columnIndex) {
            case 0: {
                rtn = this.model.getTableRow(rowIndex).getId();
                break;
            }
            case 1: {
                rtn = this.model.getTableRow(rowIndex).getFriendlyName();
                break;
            }
            case 2: {
                String major = this.model.majorIntToString(this.model.getTableRow(rowIndex).getMajor());
                String minor = this.model.minorIntToString(this.model.getTableRow(rowIndex).getMajor(), this.model.getTableRow(rowIndex).getMinor());
                rtn = major + " - " + minor;
                break;
            }
            default: {
                rtn = "";
            }
        }
        return rtn;
    }

    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    public String getColumnName(int i) {
        String columnName = "";
        switch (i) {
            case 0: {
                columnName = "";
                break;
            }
            case 1: {
                columnName = "Name";
                break;
            }
            case 2: {
                columnName = "Type";
                break;
            }
            default: {
                columnName = "Invalid Col. No.";
            }
        }
        return columnName;
    }
}

