/*
 * Decompiled with CFR 0.152.
 */
package bluepot.pkgView.Sensors.Sensor;

import bluepot.pkgModel.Model;
import bluepot.pkgView.StatFactory.GraphFactory;
import bluepot.pkgView.StatFactory.ListManager;
import bluepot.pkgView.View;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.TitledBorder;
import net.miginfocom.swing.MigLayout;
import org.jdesktop.swingx.JXTitledPanel;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;

public class Status
extends JPanel {
    int sensorId;
    View view;
    Model model;
    private final GraphFactory graphCreator;
    private final ChartPanel panel;
    private final JTextArea txtLog;
    private final JScrollPane scrollPane;
    private final JLabel txtConnsRcvd;
    private ImageIcon icnTick = new ImageIcon("icons/tick.png");
    private ImageIcon icnAttacker = new ImageIcon("icons/user.png");
    private ImageIcon icnConn = new ImageIcon("icons/bug.png");
    private ImageIcon icnFiles = new ImageIcon("icons/folder.png");
    private ImageIcon icnRandom = new ImageIcon("icons/time.png");
    private ImageIcon icnPhone = new ImageIcon("icons/phone.png");
    private ImageIcon icnDev = new ImageIcon("icons/application_form.png");
    private ImageIcon icnTag = new ImageIcon("icons/tag_blue.png");
    private ImageIcon icnZm = new ImageIcon("icons/zoom.png");
    private final JLabel txtUniqueAttackers;
    private final JLabel txtDeviceName;
    private final JLabel txtDeviceClass;
    private final JLabel txtDeviceAddress;
    private final JLabel txtDeviceVisibility;
    private final ListManager listManager;

    public Status(int sensorId, View view, Model model) {
        super(new MigLayout("wrap 1"));
        this.view = view;
        this.model = model;
        this.sensorId = sensorId;
        Font txtFont = new Font("Arial", 1, 12);
        JLabel title = new JLabel("<html><strong>Sensor " + (sensorId - 1) + "</strong></html>");
        JLabel connectionsRcvd = new JLabel("Connections Rcvd:", this.icnConn, 2);
        this.txtConnsRcvd = new JLabel("0");
        this.txtConnsRcvd.setFont(txtFont);
        JLabel deviceName = new JLabel("Device Name: ", this.icnPhone, 2);
        this.txtDeviceName = new JLabel("-");
        JLabel deviceClass = new JLabel("Device Class: ", this.icnDev, 2);
        this.txtDeviceClass = new JLabel("-");
        JLabel deviceAddress = new JLabel("Device Address: ", this.icnTag, 2);
        this.txtDeviceAddress = new JLabel("-");
        JLabel deviceVisibility = new JLabel("Device Visibility: ", this.icnZm, 2);
        this.txtDeviceVisibility = new JLabel("-");
        JLabel uniqueAttackers = new JLabel("Unique Attackers:", this.icnAttacker, 10);
        this.txtUniqueAttackers = new JLabel("0");
        this.txtUniqueAttackers.setFont(txtFont);
        this.listManager = new ListManager();
        JXTitledPanel sensorStatus = new JXTitledPanel("Sensor Status");
        JPanel snsrStatus = new JPanel(new MigLayout("wrap 2"));
        JPanel snsrInfo = new JPanel(new MigLayout("wrap 2"));
        snsrInfo.setBorder(new TitledBorder("Sensor Information"));
        snsrInfo.add((Component)title, "span 2");
        snsrInfo.add(deviceName);
        snsrInfo.add(this.txtDeviceName);
        this.txtDeviceName.setFont(txtFont);
        snsrInfo.add(deviceClass);
        snsrInfo.add(this.txtDeviceClass);
        this.txtDeviceClass.setFont(txtFont);
        snsrInfo.add(deviceAddress);
        snsrInfo.add(this.txtDeviceAddress);
        this.txtDeviceAddress.setFont(txtFont);
        snsrInfo.add(deviceVisibility);
        snsrInfo.add(this.txtDeviceVisibility);
        this.txtDeviceVisibility.setFont(txtFont);
        snsrInfo.add(connectionsRcvd);
        snsrInfo.add(this.txtConnsRcvd);
        snsrInfo.add(uniqueAttackers);
        snsrInfo.add(this.txtUniqueAttackers);
        this.graphCreator = new GraphFactory(model, sensorId - 1, "", "", "Traffic", "Time", "Hits", GraphFactory.TYPE_TIME, this.listManager);
        this.graphCreator.updateData();
        JFreeChart chart = this.graphCreator.getChart();
        this.panel = new ChartPanel(chart);
        this.panel.setInitialDelay(0);
        this.txtLog = new JTextArea(30, 100);
        this.txtLog.setEditable(false);
        this.txtLog.setBackground(Color.white);
        this.txtLog.setEditable(false);
        this.txtLog.setAutoscrolls(true);
        this.txtLog.setDragEnabled(false);
        this.txtLog.setForeground(Color.black);
        this.scrollPane = new JScrollPane();
        this.scrollPane.getViewport().add(this.txtLog);
        JXTitledPanel logPanel = new JXTitledPanel("Sensor Log  ");
        JPanel lgPanel = new JPanel(new MigLayout("wrap 1"));
        lgPanel.add((Component)this.scrollPane, "w 100%");
        logPanel.add((Component)lgPanel);
        snsrStatus.add((Component)snsrInfo, "w 50%, h 100%");
        snsrStatus.add((Component)this.panel);
        sensorStatus.add((Component)snsrStatus);
        this.add((Component)sensorStatus, "w 100%, h 40%");
        this.add((Component)logPanel, "w 100%, h 60%");
        this.deviceChange();
    }

    public void deviceChange() {
        int i = this.sensorId - 1;
        this.txtDeviceName.setText(this.model.getSensor(i).getFriendlyName());
        this.txtDeviceAddress.setText(this.model.getSensor(i).getAddress());
        this.txtDeviceVisibility.setText(Model.discoverableIntToString(this.model.getSensor(i).getDiscoverable()));
        String major = this.model.majorIntToString(this.model.getTableRow(i).getMajor());
        String minor = this.model.minorIntToString(this.model.getTableRow(i).getMajor(), this.model.getTableRow(i).getMinor());
        String classOfDevice = major + " - " + minor;
        this.txtDeviceClass.setText(classOfDevice);
    }

    public void updateGraphs() {
        this.graphCreator.updateData();
        this.txtConnsRcvd.setText(Integer.toString(this.listManager.getNoOfAttacks()));
        this.txtUniqueAttackers.setText(Integer.toString(this.listManager.getNoOfAttackers()));
    }

    public void addLog(String s) {
        this.txtLog.setText(Model.getDateTime() + ": " + s + "\n" + this.txtLog.getText());
    }
}

