/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance.painterpack.gradient;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Shape;
import java.awt.image.BufferedImage;
import org.jvnet.substance.api.SubstanceColorScheme;
import org.jvnet.substance.colorschemepack.MixColorScheme;
import org.jvnet.substance.painter.gradient.BaseGradientPainter;
import org.jvnet.substance.painter.gradient.SubstanceGradientPainter;
import org.jvnet.substance.utils.SubstanceCoreUtilities;

public class MixDelegateGradientPainter
extends BaseGradientPainter {
    protected String painterName;
    protected SubstanceGradientPainter delegate;

    public MixDelegateGradientPainter(String painterName, SubstanceGradientPainter delegate) {
        this.painterName = painterName;
        this.delegate = delegate;
    }

    public String getDisplayName() {
        return this.painterName;
    }

    public void paintContourBackground(Graphics g, Component comp, int width, int height, Shape contour, boolean isFocused, SubstanceColorScheme colorScheme1, SubstanceColorScheme colorScheme2, float cyclePos, boolean hasShine, boolean useCyclePosAsInterpolation) {
        if (colorScheme1 instanceof MixColorScheme) {
            MixColorScheme mixColorScheme = (MixColorScheme)colorScheme1;
            SubstanceColorScheme[] origSchemes = mixColorScheme.getOrigSchemes();
            BufferedImage[] components = new BufferedImage[origSchemes.length];
            for (int i = 0; i < origSchemes.length; ++i) {
                components[i] = SubstanceCoreUtilities.getBlankImage((int)width, (int)height);
                Graphics2D g2d = components[i].createGraphics();
                this.delegate.paintContourBackground((Graphics)g2d, comp, width, height, contour, isFocused, origSchemes[i], colorScheme2, cyclePos, hasShine, useCyclePosAsInterpolation);
                g2d.dispose();
            }
            BufferedImage current = components[0];
            for (int i = 1; i < components.length; ++i) {
                double start = ((double)i - 0.3) / (double)components.length;
                double end = ((double)i + 0.3) / (double)components.length;
                current = SubstanceCoreUtilities.blendImagesHorizontal((BufferedImage)current, (BufferedImage)components[i], (double)start, (double)end);
            }
            Graphics2D g2d = (Graphics2D)g.create();
            g2d.drawImage((Image)current, 0, 0, null);
            g2d.dispose();
            return;
        }
        if (colorScheme2 instanceof MixColorScheme) {
            MixColorScheme mixColorScheme = (MixColorScheme)colorScheme2;
            SubstanceColorScheme[] origSchemes = mixColorScheme.getOrigSchemes();
            BufferedImage[] components = new BufferedImage[origSchemes.length];
            for (int i = 0; i < origSchemes.length; ++i) {
                components[i] = SubstanceCoreUtilities.getBlankImage((int)width, (int)height);
                Graphics2D g2d = components[i].createGraphics();
                this.delegate.paintContourBackground((Graphics)g2d, comp, width, height, contour, isFocused, colorScheme1, origSchemes[i], cyclePos, hasShine, useCyclePosAsInterpolation);
                g2d.dispose();
            }
            BufferedImage current = components[0];
            for (int i = 1; i < components.length; ++i) {
                double start = ((double)i - 0.3) / (double)components.length;
                double end = ((double)i + 0.3) / (double)components.length;
                current = SubstanceCoreUtilities.blendImagesHorizontal((BufferedImage)current, (BufferedImage)components[i], (double)start, (double)end);
            }
            Graphics2D g2d = (Graphics2D)g.create();
            g2d.drawImage((Image)current, 0, 0, null);
            g2d.dispose();
            return;
        }
        this.delegate.paintContourBackground(g, comp, width, height, contour, isFocused, colorScheme1, colorScheme2, cyclePos, hasShine, useCyclePosAsInterpolation);
    }
}

