/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance.painterpack.gradient;

import java.awt.AlphaComposite;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.image.BufferedImage;
import org.jvnet.substance.api.SubstanceColorScheme;
import org.jvnet.substance.painter.gradient.BaseGradientPainter;
import org.jvnet.substance.painter.gradient.SubstanceGradientPainter;
import org.jvnet.substance.utils.SubstanceCoreUtilities;

public abstract class WaveDelegateGradientPainter
extends BaseGradientPainter {
    protected String painterName;
    protected ColorSchemeTransformation transformation;
    protected SubstanceGradientPainter delegate;

    public WaveDelegateGradientPainter(String painterName, ColorSchemeTransformation transformation, SubstanceGradientPainter delegate) {
        this.painterName = painterName;
        this.transformation = transformation;
        this.delegate = delegate;
    }

    public String getDisplayName() {
        return this.painterName;
    }

    public void paintContourBackground(Graphics g, Component comp, int width, int height, Shape contour, boolean isFocused, SubstanceColorScheme colorScheme1, SubstanceColorScheme colorScheme2, float cyclePos, boolean hasShine, boolean useCyclePosAsInterpolation) {
        GeneralPath clipBottom = new GeneralPath();
        clipBottom.moveTo(0.0f, height);
        clipBottom.lineTo(width, height);
        clipBottom.lineTo(width, 0.0f);
        clipBottom.curveTo(5 * width / 6, height / 3, 3 * width / 4, height / 2, width / 2, height / 2);
        clipBottom.curveTo(width / 3, height / 2, width / 4, height, 0.0f, 7 * height / 8);
        clipBottom.lineTo(0.0f, height);
        BufferedImage clipShapeBottom = SubstanceCoreUtilities.createClipImage((Shape)clipBottom, (int)width, (int)height);
        BufferedImage bottomImage = SubstanceCoreUtilities.getBlankImage((int)width, (int)height);
        Graphics2D bottomGraphics = (Graphics2D)bottomImage.getGraphics();
        bottomGraphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        SubstanceColorScheme bottomColorScheme1 = this.transformation == null ? colorScheme1 : this.transformation.transform(colorScheme1);
        SubstanceColorScheme bottomColorScheme2 = this.transformation == null ? colorScheme1 : this.transformation.transform(colorScheme2);
        bottomGraphics.setComposite(AlphaComposite.Src);
        bottomGraphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        bottomGraphics.drawImage((Image)clipShapeBottom, 0, 0, null);
        bottomGraphics.setComposite(AlphaComposite.SrcAtop);
        this.delegate.paintContourBackground((Graphics)bottomGraphics, comp, width, height, contour, isFocused, bottomColorScheme1, bottomColorScheme2, cyclePos, hasShine, useCyclePosAsInterpolation);
        BufferedImage image = SubstanceCoreUtilities.getBlankImage((int)width, (int)height);
        Graphics2D graphics = (Graphics2D)image.getGraphics();
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics.setClip(contour);
        this.delegate.paintContourBackground((Graphics)graphics, comp, width, height, contour, isFocused, colorScheme1, colorScheme2, cyclePos, hasShine, useCyclePosAsInterpolation);
        graphics.drawImage((Image)bottomImage, 0, 0, null);
        graphics.setClip(null);
    }

    public static interface ColorSchemeTransformation {
        public SubstanceColorScheme transform(SubstanceColorScheme var1);
    }
}

