/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance.painterpack.gradient;

import java.awt.Color;
import java.awt.Component;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.image.BufferedImage;
import org.jvnet.substance.api.SubstanceColorScheme;
import org.jvnet.substance.painter.gradient.BaseGradientPainter;
import org.jvnet.substance.utils.SubstanceColorUtilities;
import org.jvnet.substance.utils.SubstanceCoreUtilities;

public class WaveGradientPainter
extends BaseGradientPainter {
    public String getDisplayName() {
        return "Wave";
    }

    public void paintContourBackground(Graphics g, Component comp, int width, int height, Shape contour, boolean isFocused, SubstanceColorScheme colorScheme1, SubstanceColorScheme colorScheme2, float cyclePos, boolean hasShine, boolean useCyclePosAsInterpolation) {
        BufferedImage rectangular = SubstanceCoreUtilities.getBlankImage((int)width, (int)height);
        Graphics2D rgraphics = (Graphics2D)rectangular.getGraphics();
        SubstanceColorScheme interpolationScheme1 = colorScheme1;
        SubstanceColorScheme interpolationScheme2 = useCyclePosAsInterpolation ? colorScheme2 : colorScheme1;
        double cycleCoef = 1.0 - (double)cyclePos;
        Color darkFillColor = SubstanceColorUtilities.getTopFillColor((SubstanceColorScheme)interpolationScheme1, (SubstanceColorScheme)interpolationScheme2, (double)cycleCoef, (boolean)useCyclePosAsInterpolation);
        Color midFillColor = SubstanceColorUtilities.getMidFillColor((SubstanceColorScheme)interpolationScheme1, (SubstanceColorScheme)interpolationScheme2, (double)cycleCoef, (boolean)useCyclePosAsInterpolation);
        Color lightFillColor = SubstanceColorUtilities.getBottomFillColor((SubstanceColorScheme)interpolationScheme1, (SubstanceColorScheme)interpolationScheme2, (double)cycleCoef, (boolean)useCyclePosAsInterpolation);
        if (!useCyclePosAsInterpolation) {
            lightFillColor = SubstanceColorUtilities.getInterpolatedColor((Color)interpolationScheme1.getUltraLightColor(), (Color)interpolationScheme1.getExtraLightColor(), (double)cycleCoef);
            midFillColor = SubstanceColorUtilities.getInterpolatedColor((Color)interpolationScheme1.getLightColor(), (Color)interpolationScheme1.getMidColor(), (double)cycleCoef);
            darkFillColor = SubstanceColorUtilities.getInterpolatedColor((Color)interpolationScheme1.getMidColor(), (Color)interpolationScheme1.getMidColor(), (double)cycleCoef);
        } else {
            lightFillColor = SubstanceColorUtilities.getInterpolatedColor((Color)interpolationScheme1.getUltraLightColor(), (Color)interpolationScheme2.getUltraLightColor(), (double)cycleCoef);
            midFillColor = SubstanceColorUtilities.getInterpolatedColor((Color)interpolationScheme1.getLightColor(), (Color)interpolationScheme2.getLightColor(), (double)cycleCoef);
            darkFillColor = SubstanceColorUtilities.getInterpolatedColor((Color)interpolationScheme1.getMidColor(), (Color)interpolationScheme2.getMidColor(), (double)cycleCoef);
        }
        GradientPaint gradientTop = new GradientPaint(0.0f, 0.0f, lightFillColor, width / 4, height / 2, midFillColor);
        GeneralPath clipTop = new GeneralPath();
        clipTop.moveTo(0.0f, 0.0f);
        clipTop.lineTo(width, 0.0f);
        clipTop.curveTo(5 * width / 6, height / 3, 3 * width / 4, height / 2, width / 2, height / 2);
        clipTop.curveTo(width / 3, height / 2, width / 4, height, 0.0f, 7 * height / 8);
        clipTop.lineTo(0.0f, 0.0f);
        rgraphics.setClip(clipTop);
        rgraphics.setPaint(gradientTop);
        rgraphics.fillRect(0, 0, width, height);
        GradientPaint gradientBottom = new GradientPaint(2 * width / 3, 2 * height / 3, darkFillColor, width, height, midFillColor);
        GeneralPath clipBottom = new GeneralPath();
        clipBottom.moveTo(0.0f, height);
        clipBottom.lineTo(width, height);
        clipBottom.lineTo(width, 0.0f);
        clipBottom.curveTo(5 * width / 6, height / 3, 3 * width / 4, height / 2, width / 2, height / 2);
        clipBottom.curveTo(width / 3, height / 2, width / 4, height, 0.0f, 7 * height / 8);
        clipBottom.lineTo(0.0f, height);
        rgraphics.setClip(clipBottom);
        rgraphics.setPaint(gradientBottom);
        rgraphics.fillRect(0, 0, width, height);
        rgraphics.setClip(null);
        GeneralPath mid = new GeneralPath();
        mid.moveTo(width, 0.0f);
        mid.curveTo(5 * width / 6, height / 3, 3 * width / 4, height / 2, width / 2, height / 2);
        mid.curveTo(width / 3, height / 2, width / 4, height, 0.0f, 7 * height / 8);
        rgraphics.draw(mid);
        Graphics2D graphics = (Graphics2D)g.create();
        graphics.setClip(contour);
        graphics.drawImage((Image)rectangular, 0, 0, null);
        graphics.dispose();
    }
}

