/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance.shaperpack;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.geom.GeneralPath;
import java.io.InputStream;
import javax.swing.AbstractButton;
import javax.swing.border.Border;
import org.jvnet.substance.shaper.BaseButtonShaper;
import org.jvnet.substance.shaperpack.CanonicalPath;
import org.jvnet.substance.shaperpack.ShaperRepository;
import org.jvnet.substance.utils.SubstanceCoreUtilities;
import org.jvnet.substance.utils.SubstanceOutlineUtilities;
import org.jvnet.substance.utils.border.SubstanceButtonBorder;

public abstract class BasePolygonShaper
extends BaseButtonShaper {
    protected CanonicalPath canonicalPath;
    protected double topCoef;
    protected double leftCoef;
    protected double bottomCoef;
    protected double rightCoef;

    public BasePolygonShaper(String resourceName, double topCoef, double leftCoef, double bottomCoef, double rightCoef) {
        this.topCoef = topCoef;
        this.leftCoef = leftCoef;
        this.bottomCoef = bottomCoef;
        this.rightCoef = rightCoef;
        ClassLoader cl = BasePolygonShaper.class.getClassLoader();
        InputStream is = cl.getResourceAsStream(resourceName);
        if (is == null) {
            throw new IllegalArgumentException("Resource '" + resourceName + "' not found");
        }
        this.canonicalPath = ShaperRepository.read(is);
    }

    public Dimension getPreferredSize(AbstractButton button, Dimension uiPreferredSize) {
        if (button.getClientProperty("substancelaf.buttonbordercomputed") == null) {
            boolean isBorderComputing = button.getClientProperty("substancelaf.buttonbordercomputing") != null;
            Border border = button.getBorder();
            int uiw = uiPreferredSize.width;
            int uih = uiPreferredSize.height;
            if (border instanceof SubstanceButtonBorder) {
                Insets bi = border.getBorderInsets(button);
                if (!isBorderComputing) {
                    button.setBorder(null);
                }
                uiPreferredSize.setSize(uiw - bi.left - bi.right, uih - bi.top - bi.bottom);
            } else {
                Insets bi = border.getBorderInsets(button);
                if (!isBorderComputing) {
                    button.setBorder(null);
                }
                uiPreferredSize.setSize(uiw - bi.left - bi.right, uih - bi.top - bi.bottom);
            }
            if (!isBorderComputing) {
                button.setBorder(this.getButtonBorder(button, uiPreferredSize));
                button.putClientProperty("substancelaf.buttonbordercomputed", new String());
            }
        }
        return uiPreferredSize;
    }

    public Border getButtonBorder(AbstractButton button) {
        return new SubstanceButtonBorder(((Object)((Object)this)).getClass()){

            public Insets getBorderInsets(Component c) {
                AbstractButton button;
                if (c instanceof AbstractButton && SubstanceCoreUtilities.hasText((AbstractButton)(button = (AbstractButton)c))) {
                    if (button.getClientProperty("substancelaf.buttonbordercomputing") != null) {
                        return new Insets(0, 0, 0, 0);
                    }
                    button.putClientProperty("substancelaf.buttonbordercomputing", new String());
                    int width = button.getPreferredSize().width;
                    int height = button.getPreferredSize().height;
                    button.putClientProperty("substancelaf.buttonbordercomputing", null);
                    double finalWidth = (double)width * (1.0 + BasePolygonShaper.this.leftCoef + BasePolygonShaper.this.rightCoef);
                    double finalHeight = (double)height * (1.0 + BasePolygonShaper.this.topCoef + BasePolygonShaper.this.bottomCoef);
                    double finalRatio = finalWidth / finalHeight;
                    int dx = 0;
                    int dy = 0;
                    if (finalRatio > BasePolygonShaper.this.canonicalPath.getRatio()) {
                        dy = (int)(finalWidth / BasePolygonShaper.this.canonicalPath.getRatio() - finalHeight);
                    } else {
                        dx = (int)(BasePolygonShaper.this.canonicalPath.getRatio() * finalHeight - finalWidth);
                    }
                    return new Insets((int)(BasePolygonShaper.this.topCoef * (double)height) + dy / 2, (int)(BasePolygonShaper.this.leftCoef * (double)width) + dx / 2, (int)(BasePolygonShaper.this.bottomCoef * (double)height) + dy / 2, (int)(BasePolygonShaper.this.rightCoef * (double)width) + dx / 2);
                }
                return new Insets(0, 0, 0, 0);
            }
        };
    }

    public Border getButtonBorder(AbstractButton button, final Dimension preferredSize) {
        return new SubstanceButtonBorder(((Object)((Object)this)).getClass()){

            public Insets getBorderInsets(Component c) {
                AbstractButton button;
                if (c instanceof AbstractButton && SubstanceCoreUtilities.hasText((AbstractButton)(button = (AbstractButton)c))) {
                    int width = preferredSize.width;
                    int height = preferredSize.height;
                    double finalWidth = (double)width * (1.0 + BasePolygonShaper.this.leftCoef + BasePolygonShaper.this.rightCoef);
                    double finalHeight = (double)height * (1.0 + BasePolygonShaper.this.topCoef + BasePolygonShaper.this.bottomCoef);
                    double finalRatio = finalWidth / finalHeight;
                    int dx = 0;
                    int dy = 0;
                    if (finalRatio > BasePolygonShaper.this.canonicalPath.getRatio()) {
                        dy = (int)(finalWidth / BasePolygonShaper.this.canonicalPath.getRatio() - finalHeight);
                    } else {
                        dx = (int)(BasePolygonShaper.this.canonicalPath.getRatio() * finalHeight - finalWidth);
                    }
                    return new Insets((int)(BasePolygonShaper.this.topCoef * (double)height) + dy / 2, (int)(BasePolygonShaper.this.leftCoef * (double)width) + dx / 2, (int)(BasePolygonShaper.this.bottomCoef * (double)height) + dy / 2, (int)(BasePolygonShaper.this.rightCoef * (double)width) + dx / 2);
                }
                return new Insets(0, 0, 0, 0);
            }
        };
    }

    public GeneralPath getButtonOutline(AbstractButton button, Insets insets, int width, int height, boolean isInner) {
        if (SubstanceCoreUtilities.hasText((AbstractButton)button)) {
            return this.canonicalPath.getPath(width, height, insets);
        }
        return SubstanceOutlineUtilities.getBaseOutline((int)width, (int)height, (float)2.0f, null, (Insets)insets);
    }

    public boolean isProportionate() {
        return false;
    }
}

