/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance.watermarkpack;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Rectangle;
import org.jvnet.substance.api.SubstanceColorScheme;
import org.jvnet.substance.api.SubstanceSkin;
import org.jvnet.substance.utils.SubstanceColorSchemeUtilities;
import org.jvnet.substance.utils.SubstanceColorUtilities;
import org.jvnet.substance.utils.SubstanceCoreUtilities;
import org.jvnet.substance.watermark.SubstanceWatermark;

public class SubstanceMosaicWatermark
implements SubstanceWatermark {
    private static Image watermarkImage = null;

    public void drawWatermarkImage(Graphics graphics, Component c, int x, int y, int width, int height) {
        if (!c.isShowing()) {
            return;
        }
        int dx = c.getLocationOnScreen().x;
        int dy = c.getLocationOnScreen().y;
        graphics.drawImage(watermarkImage, x, y, x + width, y + height, x + dx, y + dy, x + dx + width, y + dy + height, null);
    }

    public boolean updateWatermarkImage(SubstanceSkin skin) {
        GraphicsDevice[] gds;
        Rectangle virtualBounds = new Rectangle();
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        for (GraphicsDevice gd : gds = ge.getScreenDevices()) {
            GraphicsConfiguration gc = gd.getDefaultConfiguration();
            virtualBounds = virtualBounds.union(gc.getBounds());
        }
        int screenWidth = virtualBounds.width;
        int screenHeight = virtualBounds.height;
        watermarkImage = SubstanceCoreUtilities.getBlankImage((int)screenWidth, (int)screenHeight);
        Graphics2D graphics = (Graphics2D)watermarkImage.getGraphics().create();
        boolean status = this.drawWatermarkImage(skin, graphics, 0, 0, screenWidth, screenHeight, false);
        graphics.dispose();
        return status;
    }

    public void previewWatermark(Graphics g, int x, int y, int width, int height) {
        this.drawWatermarkImage(SubstanceColorSchemeUtilities.METALLIC_SKIN, (Graphics2D)g, x, y, width, height, true);
    }

    private boolean drawWatermarkImage(SubstanceSkin skin, Graphics2D graphics, int x, int y, int width, int height, boolean isPreview) {
        int sqDim = 7;
        int sqGap = 2;
        int cellDim = sqDim + sqGap;
        SubstanceColorScheme scheme = skin.getWatermarkColorScheme();
        int rows = height / cellDim;
        int columns = width / cellDim;
        for (int col = 0; col <= columns; ++col) {
            for (int row = 0; row <= rows; ++row) {
                double val = isPreview ? Math.abs(Math.sin(1 + col + columns * row)) : Math.random();
                int delta = isPreview ? (int)(150.0 * val) : (int)(50.0 * val);
                int alpha = 0;
                alpha = isPreview ? 50 + delta : (scheme.isDark() ? 50 + delta * 3 / 2 : 25 + delta);
                alpha = Math.min(alpha, 255);
                Color stampColor = null;
                if (isPreview) {
                    stampColor = SubstanceCoreUtilities.getSkin(null).getMainActiveColorScheme().isDark() ? Color.lightGray : Color.darkGray;
                    stampColor = SubstanceColorUtilities.getAlphaColor((Color)stampColor, (int)alpha);
                } else {
                    stampColor = SubstanceColorUtilities.getAlphaColor((Color)scheme.getWatermarkStampColor(), (int)alpha);
                }
                graphics.setColor(stampColor);
                graphics.fillRect(x + col * cellDim, y + row * cellDim, sqDim, sqDim);
            }
        }
        return true;
    }

    public String getDisplayName() {
        return "Square Mosaic";
    }

    public void dispose() {
        watermarkImage = null;
    }
}

