/*
 * Decompiled with CFR 0.152.
 */
package uk.co.westhawk.snmp.pdu;

import java.io.IOException;
import uk.co.westhawk.snmp.pdu.InterfaceGetNextPduStub;
import uk.co.westhawk.snmp.pdu.OneIntPdu;
import uk.co.westhawk.snmp.stack.PduException;
import uk.co.westhawk.snmp.stack.SnmpContextBasisFace;

public class InterfaceGetNextPdu
extends InterfaceGetNextPduStub {
    private static final String version_id = "@(#)$Id: InterfaceGetNextPdu.java,v 3.17 2008/05/06 10:17:06 birgita Exp $ Copyright Westhawk Ltd";
    protected long _speed;

    public InterfaceGetNextPdu(SnmpContextBasisFace con) {
        super(con);
    }

    public long getSpeed() {
        return this._speed;
    }

    public long getSpeed(InterfaceGetNextPdu old) {
        this._speed = -1L;
        if (this._ifOperStatus > 0 && old._ifOperStatus > 0 && this._valid && old._valid) {
            long tdiff = this._sysUpTime - old._sysUpTime;
            if (tdiff != 0L) {
                long inO = this._ifInOctets - old._ifInOctets;
                long outO = this._ifOutOctets - old._ifOutOctets;
                this._speed = 100L * (inO + outO) / tdiff;
            }
        } else {
            this._speed = -1L;
        }
        return this._speed;
    }

    public static int getIfNumber(SnmpContextBasisFace con) throws PduException, IOException {
        int ifNumber = 0;
        if (con != null) {
            Integer intValue;
            OneIntPdu ifNumberPdu = new OneIntPdu(con, "1.3.6.1.2.1.2.1.0");
            boolean answered = ifNumberPdu.waitForSelf();
            boolean timedOut = ifNumberPdu.isTimedOut();
            if (!timedOut && (intValue = ifNumberPdu.getValue()) != null) {
                ifNumber = intValue;
            }
        }
        return ifNumber;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(this.getClass().getName());
        buffer.append("[");
        buffer.append(super.toString());
        buffer.append(", speed=").append(this._speed);
        buffer.append("]");
        return buffer.toString();
    }
}

