/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.mibble;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;
import net.percederberg.grammatica.parser.ParseException;
import net.percederberg.grammatica.parser.ParserLogException;
import net.percederberg.mibble.MibException;
import net.percederberg.mibble.MibFileRef;

public class MibLoaderLog {
    private ArrayList<LogEntry> entries = new ArrayList();
    private int errors = 0;
    private int warnings = 0;

    public int errorCount() {
        return this.errors;
    }

    public int warningCount() {
        return this.warnings;
    }

    public void add(LogEntry entry) {
        if (entry.isError()) {
            ++this.errors;
        }
        if (entry.isWarning()) {
            ++this.warnings;
        }
        this.entries.add(entry);
    }

    public void addInternalError(String message) {
        this.add(new LogEntry(1, new MibFileRef(), message));
    }

    public void addError(MibException e) {
        this.add(new LogEntry(2, e.getFileRef(), e.getMessage()));
    }

    public void addError(MibFileRef fileRef, String message) {
        this.add(new LogEntry(2, fileRef, message));
    }

    public void addWarning(MibFileRef fileRef, String message) {
        this.add(new LogEntry(3, fileRef, message));
    }

    public void addAll(MibLoaderLog log) {
        for (LogEntry entry : log.entries) {
            this.add(entry);
        }
    }

    void addAll(File file, ParserLogException log) {
        for (int i = 0; i < log.getErrorCount(); ++i) {
            ParseException e = log.getError(i);
            MibFileRef ref = new MibFileRef(file, e.getLine(), e.getColumn());
            this.addError(ref, e.getErrorMessage());
        }
    }

    public Iterator<LogEntry> entries() {
        return this.entries.iterator();
    }

    public void printTo(PrintStream output) {
        this.printTo(new PrintWriter(output));
    }

    public void printTo(PrintWriter output) {
        this.printTo(output, 70);
    }

    public void printTo(PrintWriter output, int margin) {
        StringBuilder buffer = new StringBuilder();
        for (LogEntry entry : this.entries) {
            buffer.setLength(0);
            switch (entry.getType()) {
                case 2: {
                    buffer.append("Error: ");
                    break;
                }
                case 3: {
                    buffer.append("Warning: ");
                    break;
                }
                default: {
                    buffer.append("Internal Error: ");
                }
            }
            buffer.append("in ");
            buffer.append(this.relativeFilename(entry.getFile()));
            if (entry.getLineNumber() > 0) {
                buffer.append(": line ");
                buffer.append(entry.getLineNumber());
            }
            buffer.append(":\n");
            String str = this.linebreakString(entry.getMessage(), "    ", margin);
            buffer.append(str);
            str = entry.readLine();
            if (str != null && str.length() >= entry.getColumnNumber()) {
                buffer.append("\n\n");
                buffer.append(str);
                buffer.append("\n");
                for (int j = 1; j < entry.getColumnNumber(); ++j) {
                    if (str.charAt(j - 1) == '\t') {
                        buffer.append("\t");
                        continue;
                    }
                    buffer.append(" ");
                }
                buffer.append("^");
            }
            output.println(buffer.toString());
        }
        output.flush();
    }

    private String relativeFilename(File file) {
        if (file == null) {
            return "<unknown file>";
        }
        try {
            String currentPath = new File(".").getCanonicalPath();
            String filePath = file.getCanonicalPath();
            if (filePath.startsWith(currentPath)) {
                if ((filePath = filePath.substring(currentPath.length())).charAt(0) == '/' || filePath.charAt(0) == '\\') {
                    return filePath.substring(1);
                }
                return filePath;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return file.toString();
    }

    private String linebreakString(String str, String prefix, int length) {
        int pos;
        StringBuilder buffer = new StringBuilder();
        while (str.length() + prefix.length() > length && ((pos = str.lastIndexOf(32, length - prefix.length())) >= 0 || (pos = str.indexOf(32)) >= 0)) {
            buffer.append(prefix);
            buffer.append(str.substring(0, pos));
            str = str.substring(pos + 1);
            buffer.append("\n");
        }
        buffer.append(prefix);
        buffer.append(str);
        return buffer.toString();
    }

    public class LogEntry {
        public static final int INTERNAL_ERROR = 1;
        public static final int ERROR = 2;
        public static final int WARNING = 3;
        private int type;
        private MibFileRef fileRef;
        private String message;

        public LogEntry(int type, MibFileRef fileRef, String message) {
            this.type = type;
            this.fileRef = fileRef == null || fileRef.getFile() == null ? new MibFileRef(new File("<unknown file>"), -1, -1) : fileRef;
            this.message = message;
        }

        public boolean isError() {
            return this.type == 1 || this.type == 2;
        }

        public boolean isWarning() {
            return this.type == 3;
        }

        public int getType() {
            return this.type;
        }

        public File getFile() {
            return this.fileRef.getFile();
        }

        public int getLineNumber() {
            return this.fileRef.getLineNumber();
        }

        public int getColumnNumber() {
            return this.fileRef.getColumnNumber();
        }

        public String getMessage() {
            return this.message;
        }

        public String readLine() {
            return this.fileRef.readLine();
        }
    }
}

