/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.mibble;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;

public class MibSource {
    private File file = null;
    private URL url = null;
    private Reader input = null;

    public MibSource(File file) {
        this.file = file;
    }

    public MibSource(URL url) {
        this.url = url;
    }

    public MibSource(String path, URL url) {
        this.file = new File(path);
        this.url = url;
    }

    protected MibSource(Reader input) {
        this.input = input;
    }

    public boolean equals(Object obj) {
        if (obj instanceof MibSource) {
            MibSource src = (MibSource)obj;
            if (this.url != null) {
                return this.url.equals(src.url);
            }
            if (this.file != null) {
                return this.file.equals(src.file);
            }
        }
        return false;
    }

    public int hashCode() {
        if (this.url != null) {
            return this.url.hashCode();
        }
        if (this.file != null) {
            return this.file.hashCode();
        }
        return super.hashCode();
    }

    public File getFile() {
        return this.file;
    }

    public URL getURL() {
        return this.url;
    }

    public Reader getReader() throws IOException {
        if (this.input != null) {
            return this.input;
        }
        if (this.url != null) {
            return new InputStreamReader(this.url.openStream());
        }
        return new FileReader(this.file);
    }
}

