/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.mibble;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import net.percederberg.mibble.Mib;
import net.percederberg.mibble.MibLoader;
import net.percederberg.mibble.MibLoaderException;

public class MibbleValidator {
    private static final String COMMAND_HELP = "Validates a set of SNMP MIB files. This program comes with\nABSOLUTELY NO WARRANTY; for details see the LICENSE.txt file.\n\nSyntax: MibbleValidator <file(s) or URL(s)>";
    private static final String INTERNAL_ERROR = "INTERNAL ERROR: An internal error has been found. Please report\n    this error to the maintainers (see the web site for\n    instructions). Be sure to include the version number, as\n    well as the text below:\n";

    public static void main(String[] args) {
        if (args.length < 1) {
            MibbleValidator.printHelp("No file(s) specified");
            System.exit(1);
        }
        ArrayList<Object> queue = new ArrayList<Object>();
        for (String arg : args) {
            try {
                if (arg.contains(":")) {
                    queue.add(new URL(arg));
                    continue;
                }
                File file = new File(arg);
                if (!file.exists()) {
                    System.out.println("Warning: Skipping " + arg + ": file not found");
                    continue;
                }
                if (file.isDirectory()) {
                    MibbleValidator.addMibs(file, queue);
                    continue;
                }
                queue.add(file);
            }
            catch (MalformedURLException e) {
                System.out.println("Warning: Skipping " + arg + ": " + e.getMessage());
            }
        }
        MibLoader loader = new MibLoader();
        int errors = 0;
        int warnings = 0;
        for (int i = 0; i < queue.size(); ++i) {
            Object src = queue.get(i);
            System.out.print(i + 1);
            System.out.print("/");
            System.out.print(queue.size());
            System.out.print(": Reading " + src + "... ");
            System.out.flush();
            try {
                loader.unloadAll();
                Mib mib = null;
                if (src instanceof URL) {
                    loader.removeAllDirs();
                    mib = loader.load((URL)src);
                } else {
                    File file = (File)src;
                    if (!loader.hasDir(file.getParentFile())) {
                        loader.removeAllDirs();
                        loader.addDir(file.getParentFile());
                    }
                    mib = loader.load(file);
                }
                System.out.println("[OK]");
                if (mib.getLog().warningCount() <= 0) continue;
                mib.getLog().printTo(System.out);
                ++warnings;
                continue;
            }
            catch (FileNotFoundException e) {
                System.out.println("[FAILED]");
                MibbleValidator.printError(src.toString(), e);
                ++errors;
                continue;
            }
            catch (IOException e) {
                System.out.println("[FAILED]");
                MibbleValidator.printError(src.toString(), e);
                ++errors;
                continue;
            }
            catch (MibLoaderException e) {
                System.out.println("[FAILED]");
                e.getLog().printTo(System.out);
                ++errors;
                continue;
            }
            catch (RuntimeException e) {
                System.out.println();
                MibbleValidator.printInternalError(e);
                System.exit(1);
            }
        }
        System.out.println();
        System.out.println("Files processed:  " + queue.size());
        System.out.println("  with errors:    " + errors);
        System.out.println("  with warnings:  " + warnings);
        if (errors > 0) {
            System.err.println("Error: validation errors were encountered");
        }
        System.exit(errors);
    }

    private static void printHelp(String error) {
        System.err.println(COMMAND_HELP);
        System.err.println();
        if (error != null) {
            System.err.print("Error: ");
            System.err.println(error);
            System.err.println();
        }
    }

    private static void printInternalError(Exception e) {
        System.err.println(INTERNAL_ERROR);
        e.printStackTrace();
    }

    private static void printError(String file, FileNotFoundException e) {
        StringBuilder buffer = new StringBuilder();
        buffer.append("Error: couldn't open file:");
        buffer.append("\n    ");
        buffer.append(file);
        System.out.println(buffer.toString());
    }

    private static void printError(String url, IOException e) {
        StringBuilder buffer = new StringBuilder();
        buffer.append("Error: couldn't open URL:");
        buffer.append("\n    ");
        buffer.append(url);
        System.out.println(buffer.toString());
    }

    private static void addMibs(File dir, ArrayList<Object> queue) {
        File[] files = dir.listFiles();
        if (files != null) {
            for (File file : files) {
                if (file.isHidden()) continue;
                if (file.isDirectory()) {
                    MibbleValidator.addMibs(file, queue);
                    continue;
                }
                if (!MibbleValidator.isMib(file)) continue;
                queue.add(file);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean isMib(File file) {
        if (!file.canRead()) return false;
        if (!file.isFile()) {
            return false;
        }
        try (BufferedReader in = new BufferedReader(new FileReader(file));){
            String str;
            do {
                if ((str = in.readLine()) != null) continue;
                return false;
            } while ((str = str.trim()).equals("") || str.startsWith("--"));
            boolean bl = str.contains("DEFINITIONS");
            return bl;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }
}

