/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.mibble.snmp;

import java.util.ArrayList;
import net.percederberg.mibble.MibException;
import net.percederberg.mibble.MibLoaderLog;
import net.percederberg.mibble.MibValue;
import net.percederberg.mibble.snmp.SnmpVariation;

public class SnmpModuleSupport {
    private String module;
    private ArrayList<MibValue> groups;
    private ArrayList<SnmpVariation> variations;

    public SnmpModuleSupport(String module, ArrayList<MibValue> groups, ArrayList<SnmpVariation> variations) {
        this.module = module;
        this.groups = groups;
        this.variations = variations;
    }

    void initialize(MibLoaderLog log) throws MibException {
        for (int i = 0; i < this.groups.size(); ++i) {
            this.groups.set(i, this.groups.get(i).initialize(log, null));
        }
        for (SnmpVariation var : this.variations) {
            try {
                var.initialize(log);
            }
            catch (MibException e) {
                log.addError(e);
            }
        }
    }

    public String getModule() {
        return this.module;
    }

    public ArrayList<MibValue> getGroups() {
        return this.groups;
    }

    public ArrayList<SnmpVariation> getVariations() {
        return this.variations;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        if (this.module != null) {
            buffer.append(this.module);
        }
        buffer.append("\n    Includes: ");
        buffer.append(this.groups);
        for (SnmpVariation var : this.variations) {
            buffer.append("\n    Variation: ");
            buffer.append(var);
        }
        return buffer.toString();
    }
}

