/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.mibble.snmp;

import java.util.ArrayList;
import net.percederberg.mibble.MibException;
import net.percederberg.mibble.MibLoaderLog;
import net.percederberg.mibble.MibSymbol;
import net.percederberg.mibble.MibType;
import net.percederberg.mibble.MibValue;
import net.percederberg.mibble.MibValueSymbol;
import net.percederberg.mibble.snmp.SnmpStatus;
import net.percederberg.mibble.snmp.SnmpType;
import net.percederberg.mibble.value.ObjectIdentifierValue;

public class SnmpNotificationType
extends SnmpType {
    private ArrayList<MibValue> objects;
    private SnmpStatus status;
    private String reference;

    public SnmpNotificationType(ArrayList<MibValue> objects, SnmpStatus status, String description, String reference) {
        super("NOTIFICATION-TYPE", description);
        this.objects = objects;
        this.status = status;
        this.reference = reference;
    }

    @Override
    public MibType initialize(MibSymbol symbol, MibLoaderLog log) throws MibException {
        if (!(symbol instanceof MibValueSymbol)) {
            throw new MibException(symbol.getFileRef(), "only values can have the " + this.getName() + " type");
        }
        for (int i = 0; i < this.objects.size(); ++i) {
            this.objects.set(i, this.objects.get(i).initialize(log, null));
        }
        return this;
    }

    @Override
    public boolean isCompatible(MibValue value) {
        return value instanceof ObjectIdentifierValue;
    }

    public ArrayList<MibValue> getObjects() {
        return this.objects;
    }

    public SnmpStatus getStatus() {
        return this.status;
    }

    public String getReference() {
        return this.reference;
    }

    @Override
    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append(super.toString());
        buffer.append(" (");
        buffer.append("\n  Objects: ");
        buffer.append(this.objects);
        buffer.append("\n  Status: ");
        buffer.append(this.status);
        buffer.append("\n  Description: ");
        buffer.append(this.getDescription("               "));
        if (this.reference != null) {
            buffer.append("\n  Reference: ");
            buffer.append(this.reference);
        }
        buffer.append("\n)");
        return buffer.toString();
    }
}

