/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.mibble.type;

import java.util.ArrayList;
import net.percederberg.mibble.MibException;
import net.percederberg.mibble.MibLoaderLog;
import net.percederberg.mibble.MibType;
import net.percederberg.mibble.MibValue;
import net.percederberg.mibble.type.Constraint;

public class CompoundConstraint
implements Constraint {
    private Constraint first;
    private Constraint second;

    public CompoundConstraint(Constraint first, Constraint second) {
        this.first = first;
        this.second = second;
    }

    @Override
    public void initialize(MibType type, MibLoaderLog log) throws MibException {
        this.first.initialize(type, log);
        this.second.initialize(type, log);
    }

    @Override
    public boolean isCompatible(MibType type) {
        return this.first.isCompatible(type) && this.second.isCompatible(type);
    }

    @Override
    public boolean isCompatible(MibValue value) {
        return this.first.isCompatible(value) || this.second.isCompatible(value);
    }

    public ArrayList<Constraint> getConstraintList() {
        ArrayList<Constraint> list = new ArrayList<Constraint>();
        if (this.first instanceof CompoundConstraint) {
            list.addAll(((CompoundConstraint)this.first).getConstraintList());
        } else {
            list.add(this.first);
        }
        if (this.second instanceof CompoundConstraint) {
            list.addAll(((CompoundConstraint)this.second).getConstraintList());
        } else {
            list.add(this.second);
        }
        return list;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.first.toString());
        buffer.append(" | ");
        buffer.append(this.second.toString());
        return buffer.toString();
    }
}

