/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.mibble.type;

import java.util.ArrayList;
import net.percederberg.mibble.MibException;
import net.percederberg.mibble.MibFileRef;
import net.percederberg.mibble.MibLoaderLog;
import net.percederberg.mibble.MibType;
import net.percederberg.mibble.MibValue;
import net.percederberg.mibble.type.CompoundConstraint;
import net.percederberg.mibble.type.Constraint;
import net.percederberg.mibble.type.IntegerType;
import net.percederberg.mibble.type.SequenceOfType;
import net.percederberg.mibble.type.StringType;
import net.percederberg.mibble.type.ValueConstraint;
import net.percederberg.mibble.type.ValueRangeConstraint;
import net.percederberg.mibble.value.NumberValue;
import net.percederberg.mibble.value.StringValue;

public class SizeConstraint
implements Constraint {
    private MibFileRef fileRef;
    private Constraint values;

    public SizeConstraint(MibFileRef fileRef, Constraint values) {
        this.fileRef = fileRef;
        this.values = values;
    }

    @Override
    public void initialize(MibType type, MibLoaderLog log) throws MibException {
        this.values.initialize(new IntegerType(), log);
        if (this.fileRef != null && !this.isCompatible(type)) {
            String message = "size constraint not compatible with this type";
            log.addWarning(this.fileRef, message);
        }
        this.fileRef = null;
    }

    @Override
    public boolean isCompatible(MibType type) {
        return type instanceof SequenceOfType || type instanceof StringType;
    }

    @Override
    public boolean isCompatible(MibValue value) {
        if (value instanceof StringValue) {
            Integer size = new Integer(value.toString().length());
            return this.values.isCompatible(new NumberValue(size));
        }
        return false;
    }

    public ArrayList<Constraint> getValues() {
        if (this.values instanceof CompoundConstraint) {
            return ((CompoundConstraint)this.values).getConstraintList();
        }
        ArrayList<Constraint> list = new ArrayList<Constraint>();
        list.add(this.values);
        return list;
    }

    public int nextValue(int start) {
        for (Constraint c : this.getValues()) {
            Object obj = null;
            if (c instanceof ValueConstraint) {
                obj = ((ValueConstraint)c).getValue().toObject();
            } else if (c instanceof ValueRangeConstraint) {
                if (((ValueRangeConstraint)c).isCompatible(new Integer(start))) {
                    return start;
                }
                obj = ((ValueRangeConstraint)c).getLowerBound().toObject();
            }
            if (!(obj instanceof Number) || start > ((Number)obj).intValue()) continue;
            return ((Number)obj).intValue();
        }
        return -1;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("SIZE (");
        buffer.append(this.values);
        buffer.append(")");
        return buffer.toString();
    }
}

