/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.mibble.value;

import java.math.BigInteger;
import net.percederberg.mibble.MibLoaderLog;
import net.percederberg.mibble.MibType;
import net.percederberg.mibble.MibValue;
import net.percederberg.mibble.value.NumberValue;

public class BinaryNumberValue
extends NumberValue {
    private int minLength;

    public BinaryNumberValue(Number value) {
        this(value, 1);
    }

    public BinaryNumberValue(Number value, int minLength) {
        super(value);
        this.minLength = minLength;
    }

    @Override
    public MibValue initialize(MibLoaderLog log, MibType type) {
        int bytes = this.minLength / 8 + (this.minLength % 8 > 0 ? 1 : 0);
        int length = this.getByteSize(type, bytes) * 8;
        if (length > this.minLength) {
            this.minLength = length;
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("'");
        String value = this.toBinaryString();
        if (value.equals("0")) {
            value = "";
        }
        for (int i = value.length(); i < this.minLength; ++i) {
            buffer.append("0");
        }
        buffer.append(value);
        buffer.append("'B");
        return buffer.toString();
    }

    private String toBinaryString() {
        Number num = (Number)this.toObject();
        if (num instanceof BigInteger) {
            return ((BigInteger)num).toString(2);
        }
        if (num instanceof Long) {
            return Long.toBinaryString(num.longValue());
        }
        return Integer.toBinaryString(num.intValue());
    }
}

