/*
 * Decompiled with CFR 0.152.
 */
package net.lukemurphey.nsia;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.lukemurphey.nsia.Application;
import net.lukemurphey.nsia.InputValidationException;
import net.lukemurphey.nsia.NoDatabaseConnectionException;

public class ApplicationParameters {
    private Pattern nameValidation = Pattern.compile("[.A-Z0-9a-z_]*");
    private static final String NAME_VALIDATION = "[.A-Z0-9a-z_]*";
    private Application application = null;

    public ApplicationParameters() {
        this.application = Application.getApplication();
    }

    public ApplicationParameters(Application app) {
        this.application = app;
    }

    public String getParameter(String name, String defaultValue) throws NoDatabaseConnectionException, SQLException, InputValidationException {
        String value;
        block10: {
            if (name == null) {
                return defaultValue;
            }
            Matcher matcher = this.nameValidation.matcher(name);
            if (!matcher.matches()) {
                throw new InputValidationException("Application parameter name is invalid; get operation failed", name, defaultValue);
            }
            Connection connection = null;
            connection = this.application.getDatabaseConnection(Application.DatabaseAccessType.ADMIN);
            if (connection == null) {
                throw new NoDatabaseConnectionException();
            }
            PreparedStatement statement = null;
            ResultSet result = null;
            value = null;
            try {
                statement = connection.prepareStatement("Select * from ApplicationParameters where Name = ?");
                statement.setString(1, name);
                result = statement.executeQuery();
                if (result.next()) {
                    value = result.getString("Value");
                    break block10;
                }
                String string = defaultValue;
                return string;
            }
            finally {
                if (result != null) {
                    result.close();
                }
                if (statement != null) {
                    statement.close();
                }
                if (connection != null) {
                    connection.close();
                }
            }
        }
        return value;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long getParameter(String name, long defaultValue) throws NoDatabaseConnectionException, SQLException, InputValidationException {
        ApplicationParameters applicationParameters = this;
        synchronized (applicationParameters) {
            if (name == null) {
                return defaultValue;
            }
            Matcher matcher = this.nameValidation.matcher(name);
            if (!matcher.matches()) {
                throw new InputValidationException("Application parameter name is invalid; get operation failed", name, String.valueOf(defaultValue));
            }
            Connection connection = null;
            connection = this.application.getDatabaseConnection(Application.DatabaseAccessType.ADMIN);
            if (connection == null) {
                throw new NoDatabaseConnectionException();
            }
            PreparedStatement statement = null;
            ResultSet result = null;
            try {
                statement = connection.prepareStatement("Select * from ApplicationParameters where Name = ?");
                statement.setString(1, name);
                result = statement.executeQuery();
                if (result.next()) {
                    long l2 = result.getLong("Value");
                    return l2;
                }
                long l = defaultValue;
                return l;
            }
            finally {
                if (result != null) {
                    result.close();
                }
                if (statement != null) {
                    statement.close();
                }
                if (connection != null) {
                    connection.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setParameter(String name, String value) throws InputValidationException, SQLException, NoDatabaseConnectionException {
        ApplicationParameters applicationParameters = this;
        synchronized (applicationParameters) {
            if (name == null) {
                throw new IllegalArgumentException("Parameter name cannot be null");
            }
            if (value == null) {
                throw new IllegalArgumentException("Parameter value cannot be null");
            }
            if (name.length() == 0) {
                throw new IllegalArgumentException("Parameter value cannot be empty");
            }
            Matcher matcher = this.nameValidation.matcher(name);
            if (!matcher.matches()) {
                throw new InputValidationException("Application parameter name is invalid; set operation failed", name, value);
            }
            Application application = this.application;
            synchronized (application) {
                Statement statement = null;
                Connection connection = null;
                try {
                    connection = Application.getApplication().getDatabaseConnection(Application.DatabaseAccessType.ADMIN);
                    if (connection == null) {
                        throw new NoDatabaseConnectionException();
                    }
                    if (this.doesParameterExist(name)) {
                        statement = connection.prepareStatement("Update ApplicationParameters set Value = ? where Name = ?");
                        statement.setString(1, value);
                        statement.setString(2, name);
                        statement.executeUpdate();
                    } else {
                        statement = connection.prepareStatement("Insert into ApplicationParameters (Name, Value) values (?, ?)");
                        statement.setString(1, name);
                        statement.setString(2, value);
                        statement.executeUpdate();
                    }
                }
                finally {
                    if (statement != null) {
                        statement.close();
                    }
                    if (connection != null) {
                        connection.close();
                    }
                }
            }
        }
    }

    public boolean doesParameterExist(String name) throws InputValidationException, NoDatabaseConnectionException, SQLException {
        String value = this.getParameter(name, null);
        return value != null;
    }
}

