/*
 * Decompiled with CFR 0.152.
 */
package net.lukemurphey.nsia;

import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ApplicationVersionDescriptor {
    private static Pattern VERSION_REGEX = Pattern.compile("([0-9]*)?([.]([0-9]*))?([.]([0-9]*))?[ ]*(\\((.*)\\))?");
    private int major;
    private int minor = -1;
    private int revision = -1;
    private String branch;
    private Date releaseDate = null;

    public ApplicationVersionDescriptor(String version) {
        this(version, null);
    }

    public ApplicationVersionDescriptor(String version, Date releaseDate) {
        Matcher matcher = VERSION_REGEX.matcher(version);
        if (matcher.find()) {
            this.major = Integer.parseInt(matcher.group(1));
            try {
                this.minor = Integer.parseInt(matcher.group(3));
            }
            catch (NumberFormatException e) {
                this.minor = -1;
            }
            try {
                this.revision = Integer.parseInt(matcher.group(5));
            }
            catch (NumberFormatException e) {
                this.revision = -1;
            }
            this.branch = matcher.group(7);
        }
        this.releaseDate = releaseDate;
    }

    public Date getReleaseDate() {
        return this.releaseDate;
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public int getRevision() {
        return this.revision;
    }

    public String getBranch() {
        return this.branch;
    }

    public String toString() {
        String versionID = "" + this.getMajor();
        if (this.getMinor() >= 0) {
            versionID = String.valueOf(versionID) + "." + this.getMinor();
            if (this.getRevision() >= 0) {
                versionID = String.valueOf(versionID) + "." + this.getRevision();
            }
        }
        if (this.getBranch() != null && this.getBranch().length() > 0) {
            versionID = String.valueOf(versionID) + " (" + this.getBranch() + ")";
        }
        return versionID;
    }

    public static boolean isLaterVersion(ApplicationVersionDescriptor current, ApplicationVersionDescriptor latestAvailable) {
        if (latestAvailable.getBranch() != null && !latestAvailable.getBranch().equalsIgnoreCase(current.getBranch())) {
            return false;
        }
        if (latestAvailable.getMajor() > current.getMajor()) {
            return true;
        }
        if (latestAvailable.getMajor() == current.getMajor() && latestAvailable.getMinor() > current.getMinor()) {
            return true;
        }
        return latestAvailable.getMajor() == current.getMajor() && latestAvailable.getMinor() == current.getMinor() && latestAvailable.getRevision() > current.getRevision();
    }
}

