/*
 * Decompiled with CFR 0.152.
 */
package net.lukemurphey.nsia;

import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.lukemurphey.nsia.Application;
import net.lukemurphey.nsia.AuthenticationValidator;
import net.lukemurphey.nsia.ClientData;
import net.lukemurphey.nsia.InputValidationException;
import net.lukemurphey.nsia.NoDatabaseConnectionException;
import net.lukemurphey.nsia.NumericalOverflowAnalysis;
import net.lukemurphey.nsia.NumericalOverflowException;

public abstract class Authentication {
    protected Application appRes = null;

    public Authentication(Application appResources) {
        this.appRes = appResources;
    }

    public AuthenticationResult authenticate(String userName, AuthenticationValidator validator, ClientData clientData) {
        return null;
    }

    protected synchronized void incrementAuthenticationFailedCount(String userName, long aggregateAttemptsTimeSeconds) throws SQLException, NumericalOverflowException, InputValidationException, NoDatabaseConnectionException {
        if (userName == null) {
            return;
        }
        if (userName.length() < 1) {
            return;
        }
        Pattern pattern = Pattern.compile("[-A-Z0-9a-z_ .]{0,256}");
        Matcher matcher = pattern.matcher(userName);
        if (!matcher.matches()) {
            throw new InputValidationException("The username contains invalid characters", "Username", userName);
        }
        if (userName.length() > 32) {
            throw new InputValidationException("The username contains too many characters (" + userName.length() + ")", "Username", userName);
        }
        Connection conn = null;
        Statement statementAttempts = null;
        Statement statementAddAuthFailed = null;
        ResultSet result = null;
        Statement increaseAttempts = null;
        try {
            conn = this.appRes.getDatabaseConnection(Application.DatabaseAccessType.USER_QUERY);
            statementAttempts = conn.prepareStatement("Select * from AttemptedLogins where Lower(LoginName) = ?");
            statementAttempts.setString(1, userName.toLowerCase());
            result = statementAttempts.executeQuery();
            if (!result.next()) {
                statementAddAuthFailed = conn.prepareStatement("Insert into AttemptedLogins (LoginName, FirstAttempted, Attempts) values(?, ?, 1)");
                statementAddAuthFailed.setString(1, userName);
                Timestamp now = new Timestamp(System.currentTimeMillis());
                statementAddAuthFailed.setString(2, now.toString());
                statementAddAuthFailed.executeUpdate();
            } else {
                long count = result.getLong("Attempts");
                Timestamp firstAttempt = result.getTimestamp("FirstAttempted");
                Timestamp now = new Timestamp(System.currentTimeMillis());
                if (now.getTime() - firstAttempt.getTime() > aggregateAttemptsTimeSeconds * 1000L) {
                    this.removeOldLoginAttemptEntries(aggregateAttemptsTimeSeconds);
                } else {
                    int attemptNameID = result.getInt("AttemptedNameID");
                    increaseAttempts = conn.prepareStatement("Update AttemptedLogins set Attempts = ? where AttemptedNameID = ?");
                    if (!NumericalOverflowAnalysis.assertSafeIncrement(count)) {
                        throw new NumericalOverflowException("Attempt to increment failed login count overflowed for username: " + userName, "Failed Login Attempt Count");
                    }
                    increaseAttempts.setLong(1, count + 1L);
                    increaseAttempts.setInt(2, attemptNameID);
                    increaseAttempts.executeUpdate();
                }
            }
        }
        finally {
            if (result != null) {
                result.close();
            }
            if (statementAttempts != null) {
                statementAttempts.close();
            }
            if (statementAddAuthFailed != null) {
                statementAddAuthFailed.close();
            }
            if (increaseAttempts != null) {
                increaseAttempts.close();
            }
            if (conn != null) {
                conn.close();
            }
        }
    }

    protected synchronized void clearAuthenticationFailedCount(String userName) throws SQLException, NumericalOverflowException, InputValidationException, NoDatabaseConnectionException {
        if (userName == null) {
            return;
        }
        if (userName.length() < 1) {
            return;
        }
        Pattern pattern = Pattern.compile("[-A-Z0-9a-z_ .]{0,256}");
        Matcher matcher = pattern.matcher(userName);
        if (!matcher.matches()) {
            throw new InputValidationException("The username contains invalid characters", "Username", userName);
        }
        if (userName.length() > 32) {
            throw new InputValidationException("The username contains too many characters (" + userName.length() + ")", "Username", userName);
        }
        Connection conn = null;
        Statement statementAttempts = null;
        try {
            conn = this.appRes.getDatabaseConnection(Application.DatabaseAccessType.USER_QUERY);
            statementAttempts = conn.prepareStatement("Delete from AttemptedLogins where Lower(LoginName) = ?");
            statementAttempts.setString(1, userName.toLowerCase());
            statementAttempts.execute();
        }
        finally {
            if (statementAttempts != null) {
                statementAttempts.close();
            }
            if (conn != null) {
                conn.close();
            }
        }
    }

    protected long getAuthenticationFailedCount(String userName, long aggregateAttemptsTimeSeconds) throws SQLException, NoDatabaseConnectionException {
        if (userName == null) {
            return -1L;
        }
        if (aggregateAttemptsTimeSeconds <= 0L) {
            throw new IllegalArgumentException("The time to aggregate login attempts must be non-zero.");
        }
        this.removeOldLoginAttemptEntries(aggregateAttemptsTimeSeconds);
        Statement statementAttempts = null;
        ResultSet result = null;
        Connection conn = null;
        try {
            conn = this.appRes.getDatabaseConnection(Application.DatabaseAccessType.USER_QUERY);
            statementAttempts = conn.prepareStatement("Select * from AttemptedLogins where Lower(LoginName) = ?");
            statementAttempts.setString(1, userName.toLowerCase());
            result = statementAttempts.executeQuery();
            if (result.next()) {
                long count = result.getLong("Attempts");
                Timestamp firstAttempt = result.getTimestamp("FirstAttempted");
                Timestamp now = new Timestamp(System.currentTimeMillis());
                if (now.getTime() - firstAttempt.getTime() < aggregateAttemptsTimeSeconds * 1000L) {
                    long l = count;
                    return l;
                }
                return 0L;
            }
            return 0L;
        }
        finally {
            if (result != null) {
                result.close();
            }
            if (statementAttempts != null) {
                statementAttempts.close();
            }
            if (conn != null) {
                conn.close();
            }
        }
    }

    private void removeOldLoginAttemptEntries(long aggregateAttemptsTimeSeconds) throws SQLException, NoDatabaseConnectionException {
        if (aggregateAttemptsTimeSeconds <= 0L) {
            throw new IllegalArgumentException("The time to aggregate login attempts must be non-zero.");
        }
        Timestamp old = new Timestamp(System.currentTimeMillis() - aggregateAttemptsTimeSeconds * 1000L);
        Connection conn = null;
        Statement statement = null;
        try {
            conn = this.appRes.getDatabaseConnection(Application.DatabaseAccessType.USER_QUERY);
            statement = conn.prepareStatement("Delete from AttemptedLogins where FirstAttempted < ?");
            statement.setTimestamp(1, old);
            statement.executeUpdate();
        }
        finally {
            if (statement != null) {
                statement.close();
            }
            if (conn != null) {
                conn.close();
            }
        }
    }

    protected void randomWait() throws NoSuchAlgorithmException {
        SecureRandom random = SecureRandom.getInstance("SHA1PRNG");
        long randInt = random.nextInt(2000);
        try {
            Thread.sleep(randInt);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    protected void timedDelay(long startTime, long secondsDelay) {
        long endTime = startTime + secondsDelay * 1000L;
        long diff = endTime - System.currentTimeMillis();
        if (diff > 0L) {
            try {
                Thread.sleep(diff);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public static class AuthenticationResult {
        public static final int AUTH_SUCCESS = 0;
        public static final int AUTH_FAILED = 1;
        public static final int AUTH_INVALID_PASSWORD = 2;
        public static final int AUTH_INVALID_USER = 3;
        public static final int AUTH_ACCOUNT_DISABLED = 4;
        public static final int AUTH_ACCOUNT_ADMINISTRATIVELY_LOCKED = 5;
        public static final int AUTH_ACCOUNT_BRUTE_FORCE_LOCKED = 6;
        private int authResultCode = -1;
        private int trackingNumber = -1;
        private String sessionId = null;

        protected AuthenticationResult(int authenticationResultCode, String sessionIdentifier) {
            this.authResultCode = authenticationResultCode;
            this.sessionId = sessionIdentifier;
        }

        protected AuthenticationResult(int authenticationResultCode, String sessionIdentifier, int trackingNumber) {
            this.authResultCode = authenticationResultCode;
            this.sessionId = sessionIdentifier;
            this.trackingNumber = trackingNumber;
        }

        public String getSessionIdentifier() {
            return this.sessionId;
        }

        public int getTrackingNumber() {
            return this.trackingNumber;
        }

        public int getAuthenticationStatus() {
            return this.authResultCode;
        }
    }

    public static class LoginRecord {
        private Timestamp loginDate;
        private String loginLocation;
        private long userID;

        protected LoginRecord(Timestamp date, String fromLocation, long userID) {
            this.loginDate = date;
            this.loginLocation = fromLocation;
            this.userID = userID;
        }

        public Timestamp getLoginDate() {
            return this.loginDate;
        }

        public long getUserID() {
            return this.userID;
        }

        public String getLoginLocation() {
            return this.loginLocation;
        }
    }
}

