/*
 * Decompiled with CFR 0.152.
 */
package net.lukemurphey.nsia;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Vector;
import net.lukemurphey.nsia.NoDatabaseConnectionException;

public abstract class DatabaseInitializer {
    protected Connection connection = null;
    protected String[] tableList;
    protected String[] indexList;

    public DatabaseInitializer(Connection connection) {
        this.connection = connection;
    }

    protected boolean doesTableExist(String tableName) {
        int c = 0;
        while (c < this.tableList.length) {
            if (this.tableList[c].equalsIgnoreCase(tableName)) {
                return true;
            }
            ++c;
        }
        return false;
    }

    protected void populateIndexList() throws SQLException, NoDatabaseConnectionException {
        Vector<String> indexListVector = new Vector<String>();
        ResultSet rs = null;
        DatabaseMetaData dbm = this.getConnection().getMetaData();
        rs = dbm.getIndexInfo(null, null, null, false, true);
        while (rs.next()) {
            String str = rs.getString("INDEX_NAME");
            indexListVector.add(str);
        }
        this.indexList = new String[indexListVector.size()];
        int c = 0;
        while (c < indexListVector.size()) {
            this.indexList[c] = (String)indexListVector.get(c);
            ++c;
        }
    }

    protected void populateTableList() throws SQLException, NoDatabaseConnectionException {
        Vector<String> tableListVector = new Vector<String>();
        ResultSet rs = null;
        DatabaseMetaData dbm = this.getConnection().getMetaData();
        String[] types = new String[]{"TABLE"};
        rs = dbm.getTables(null, null, null, types);
        while (rs.next()) {
            String str = rs.getString("TABLE_NAME");
            tableListVector.add(str);
        }
        this.tableList = new String[tableListVector.size()];
        int c = 0;
        while (c < tableListVector.size()) {
            this.tableList[c] = (String)tableListVector.get(c);
            ++c;
        }
    }

    public DatabaseInitializationState performSetup() throws SQLException, NoDatabaseConnectionException {
        return this.performSetup(true);
    }

    public DatabaseInitializationState performSetup(boolean autoCloseConnection) throws SQLException, NoDatabaseConnectionException {
        this.populateTableList();
        DatabaseInitializationState initResults = new DatabaseInitializationState();
        initResults.applicationParameters = this.createApplicationParametersTable();
        initResults.attemptedLogins = this.createAttemptedLoginsTable();
        initResults.firewall = this.createFirewallTable();
        initResults.groups = this.createGroupsTable();
        initResults.groupUsersMap = this.createGroupsUsersMapTable();
        initResults.httpHashScanRule = this.createStaticHttpRuleTable();
        initResults.httpHashScanResult = this.createStaticHttpResultsTable();
        initResults.httpHeaderScanRule = this.createStaticHttpHeaderRulesTable();
        initResults.httpHeaderScanResult = this.createStaticHttpHeaderResultsTable();
        initResults.objectMap = this.createObjectMapTable();
        initResults.performanceMetrics = this.createPerformanceMetricsTable();
        initResults.permissions = this.createPermissionsTable();
        initResults.rights = this.createRightsTable();
        initResults.scanResult = this.createScanResultTable();
        initResults.scanRule = this.createScanRuleTable();
        initResults.sessions = this.createSessionsTable();
        initResults.siteGroups = this.createSiteGroupsTable();
        initResults.users = this.createUsersTable();
        initResults.signatures = this.createDefinitionsTable();
        initResults.scriptEnvironment = this.createScriptEnvironmentTable();
        initResults.eventlog = this.createEventLogTable();
        initResults.httpDiscovery = this.createHttpDiscoveryRuleTable();
        initResults.ruleURL = this.createRuleURLTable();
        initResults.httpSignatureScanResult = this.createSignatureScanResultTable();
        initResults.matchedRules = this.createMatchedRulesTable();
        initResults.httpDiscoveryResult = this.createHttpDiscoveryResultTable();
        initResults.signatureExceptions = this.createDefinitionPolicyTable();
        initResults.serviceScanRule = this.createServiceScanRuleTable();
        initResults.serviceScanResult = this.createServiceScanResultTable();
        initResults.actions = this.createActionsTable();
        initResults.eventlogHooks = this.createEventLogHooksTable();
        initResults.definitionErrors = this.createDefinitionErrorTable();
        this.insertRights();
        if (initResults.getUsersTableState() == Result.TABLE_CREATED) {
            this.insertDefaultUser();
        }
        if (autoCloseConnection) {
            this.getConnection().close();
        }
        return initResults;
    }

    protected Connection getConnection() throws NoDatabaseConnectionException {
        if (this.connection == null) {
            throw new NoDatabaseConnectionException();
        }
        return this.connection;
    }

    protected void insertRights() throws SQLException, NoDatabaseConnectionException {
        this.insertRight("Users.Add", "Create New Users");
        this.insertRight("Users.Edit", "Edit User");
        this.insertRight("Users.View", "View Users' Details (including rights)");
        this.insertRight("Users.Delete", "Delete Users");
        this.insertRight("Users.Unlock", "Unlock Accounts (due to repeated authentication attempts)");
        this.insertRight("Users.UpdatePassword", "Update Other's Password (applies only to the other users' accounts)");
        this.insertRight("Users.UpdateOwnPassword", "Update Account Details (applies only to the users' own account)");
        this.insertRight("Users.Sessions.Delete", "Delete Users' Sessions (kick users off)");
        this.insertRight("Users.Sessions.View", "View Users' Sessions (see who is logged in)");
        this.insertRight("Groups.Add", "Create New Groups");
        this.insertRight("Groups.View", "View Groups");
        this.insertRight("Groups.Edit", "Edit Groups");
        this.insertRight("Groups.Delete", "Delete Groups");
        this.insertRight("Groups.Membership.Edit", "Manage Group Membership");
        this.insertRight("SiteGroups.View", "View Site Groups");
        this.insertRight("SiteGroups.Add", "Create New Site Group");
        this.insertRight("SiteGroups.Delete", "Delete Site Groups");
        this.insertRight("SiteGroups.Edit", "Edit Site Groups");
        this.insertRight("System.Information.View", "View System Information and Status");
        this.insertRight("System.Configuration.Edit", "Modify System Configuration");
        this.insertRight("System.Configuration.View", "View System Configuration");
        this.insertRight("System.Firewall.View", "View Firewall Configuration");
        this.insertRight("System.Firewall.Edit", "Change Firewall Configuration");
        this.insertRight("System.ControlScanner", "Start/Stop Scanner");
        this.insertRight("SiteGroups.ScanAllRules", "Allow Gratuitous Scanning of All Rules");
        this.insertRight("System.Shutdown", "Shutdown system");
    }

    protected synchronized long allocateObjectId(String databaseTableDescription) throws SQLException, NoDatabaseConnectionException {
        this.connection = this.getConnection();
        PreparedStatement statement = null;
        ResultSet result = null;
        try {
            statement = this.connection.prepareStatement("Insert into ObjectMap(\"Table\") values(?)", 1);
            statement.setString(1, databaseTableDescription);
            statement.executeUpdate();
            result = statement.getGeneratedKeys();
            if (result.next()) {
                long l = result.getLong(1);
                return l;
            }
            return -1L;
        }
        finally {
            if (statement != null) {
                statement.close();
            }
            if (result != null) {
                result.close();
            }
        }
    }

    protected boolean doesRightExist(String rightName) throws SQLException {
        PreparedStatement statement = null;
        ResultSet result = null;
        try {
            statement = this.connection.prepareStatement("select * from Rights where RightName = ?");
            statement.setString(1, rightName);
            result = statement.executeQuery();
            return result.next();
            {
            }
        }
        finally {
            if (statement != null) {
                statement.close();
            }
            if (result != null) {
                result.close();
            }
        }
    }

    protected boolean insertRight(String rightName, String rightDescription) throws SQLException, NoDatabaseConnectionException {
        if (this.doesRightExist(rightName)) {
            return true;
        }
        long objectId = this.allocateObjectId("UserRights");
        PreparedStatement statement = null;
        try {
            statement = this.connection.prepareStatement("insert into Rights(RightName, RightDescription, ObjectID) values (?,?,?)");
            statement.setString(1, rightName);
            statement.setString(2, rightDescription);
            statement.setLong(3, objectId);
            int results = statement.executeUpdate();
            return results > 0;
            {
            }
        }
        finally {
            if (statement != null) {
                statement.close();
            }
        }
    }

    protected void insertDefaultUser() throws SQLException, NoDatabaseConnectionException {
    }

    protected abstract Result createApplicationParametersTable() throws SQLException, NoDatabaseConnectionException;

    protected abstract Result createAttemptedLoginsTable() throws SQLException, NoDatabaseConnectionException;

    protected abstract Result createFirewallTable() throws SQLException, NoDatabaseConnectionException;

    protected abstract Result createGroupsTable() throws SQLException, NoDatabaseConnectionException;

    protected abstract Result createGroupsUsersMapTable() throws SQLException, NoDatabaseConnectionException;

    protected abstract Result createStaticHttpRuleTable() throws SQLException, NoDatabaseConnectionException;

    protected abstract Result createStaticHttpResultsTable() throws SQLException, NoDatabaseConnectionException;

    protected abstract Result createStaticHttpHeaderRulesTable() throws SQLException, NoDatabaseConnectionException;

    protected abstract Result createStaticHttpHeaderResultsTable() throws SQLException, NoDatabaseConnectionException;

    protected abstract Result createObjectMapTable() throws SQLException, NoDatabaseConnectionException;

    protected abstract Result createPerformanceMetricsTable() throws SQLException, NoDatabaseConnectionException;

    protected abstract Result createPermissionsTable() throws SQLException, NoDatabaseConnectionException;

    protected abstract Result createRightsTable() throws SQLException, NoDatabaseConnectionException;

    protected abstract Result createScanResultTable() throws SQLException, NoDatabaseConnectionException;

    protected abstract Result createScanRuleTable() throws SQLException, NoDatabaseConnectionException;

    protected abstract Result createPortScanResultTable() throws SQLException, NoDatabaseConnectionException;

    protected abstract Result createPortScanRuleTable() throws SQLException, NoDatabaseConnectionException;

    protected abstract Result createSessionsTable() throws SQLException, NoDatabaseConnectionException;

    protected abstract Result createSiteGroupsTable() throws SQLException, NoDatabaseConnectionException;

    protected abstract Result createUsersTable() throws SQLException, NoDatabaseConnectionException;

    protected abstract Result createDefinitionsTable() throws SQLException, NoDatabaseConnectionException;

    protected abstract Result createScriptEnvironmentTable() throws SQLException, NoDatabaseConnectionException;

    protected abstract Result createSpecimenArchiveTable() throws SQLException, NoDatabaseConnectionException;

    protected abstract Result createEventLogTable() throws SQLException, NoDatabaseConnectionException;

    protected abstract Result createHttpDiscoveryRuleTable() throws SQLException, NoDatabaseConnectionException;

    protected abstract Result createRuleURLTable() throws SQLException, NoDatabaseConnectionException;

    protected abstract Result createSignatureScanResultTable() throws SQLException, NoDatabaseConnectionException;

    protected abstract Result createMatchedRulesTable() throws SQLException, NoDatabaseConnectionException;

    protected abstract Result createDefinitionPolicyTable() throws SQLException, NoDatabaseConnectionException;

    protected abstract Result createHttpDiscoveryResultTable() throws SQLException, NoDatabaseConnectionException;

    protected abstract Result createServiceScanRuleTable() throws SQLException, NoDatabaseConnectionException;

    protected abstract Result createServiceScanResultTable() throws SQLException, NoDatabaseConnectionException;

    protected abstract Result createActionsTable() throws SQLException, NoDatabaseConnectionException;

    protected abstract Result createEventLogHooksTable() throws SQLException, NoDatabaseConnectionException;

    protected abstract Result createDefinitionErrorTable() throws SQLException, NoDatabaseConnectionException;

    protected abstract void postTableCreation() throws SQLException, NoDatabaseConnectionException;

    protected static class DatabaseInitializationState {
        protected Result applicationParameters;
        protected Result attemptedLogins;
        protected Result firewall;
        protected Result groups;
        protected Result groupUsersMap;
        protected Result httpHashScanResult;
        protected Result httpHashScanRule;
        protected Result httpHeaderScanResult;
        protected Result httpHeaderScanRule;
        protected Result portScanRule;
        protected Result portScanResult;
        protected Result objectMap;
        protected Result performanceMetrics;
        protected Result permissions;
        protected Result rights;
        protected Result scanResult;
        protected Result scanRule;
        protected Result sessions;
        protected Result siteGroups;
        protected Result users;
        protected Result signatures;
        protected Result scriptEnvironment;
        protected Result specimenArchive;
        protected Result eventlog;
        protected Result httpDiscovery;
        protected Result ruleURL;
        protected Result httpSignatureScanResult;
        protected Result matchedRules;
        protected Result ruleFilter;
        protected Result httpDiscoveryResult;
        protected Result signatureExceptions;
        protected Result serviceScanRule;
        protected Result serviceScanResult;
        protected Result actions;
        protected Result eventlogHooks;
        protected Result definitionErrors;

        protected DatabaseInitializationState() {
        }

        public Result getApplicationParametersTableState() {
            return this.applicationParameters;
        }

        public Result getAttemptedLoginsTableState() {
            return this.attemptedLogins;
        }

        public Result getFirewallTableState() {
            return this.firewall;
        }

        public Result getGroupsTableState() {
            return this.groups;
        }

        public Result getGroupUsersMapTableState() {
            return this.groupUsersMap;
        }

        public Result getStaticHttpScanResultTableState() {
            return this.httpHashScanResult;
        }

        public Result getStaticHttpScanRuleTableState() {
            return this.httpHashScanRule;
        }

        public Result getStaticHttpHeaderScanResultTableState() {
            return this.httpHeaderScanResult;
        }

        public Result getPortScanRuleTableState() {
            return this.portScanRule;
        }

        public Result getPortScanResultTableState() {
            return this.portScanResult;
        }

        public Result getStaticHttpHeaderScanRuleTableState() {
            return this.httpHeaderScanRule;
        }

        public Result getObjectMapTableState() {
            return this.objectMap;
        }

        public Result getPerformanceMetricsTableState() {
            return this.performanceMetrics;
        }

        public Result getPermissionsTableState() {
            return this.permissions;
        }

        public Result getRightsTableState() {
            return this.rights;
        }

        public Result getScanResultTableState() {
            return this.scanResult;
        }

        public Result getScanRuleTableState() {
            return this.scanRule;
        }

        public Result getSessionsTableState() {
            return this.sessions;
        }

        public Result getSiteGroupsTableState() {
            return this.siteGroups;
        }

        public Result getUsersTableState() {
            return this.users;
        }

        public Result getSignaturesTableState() {
            return this.signatures;
        }

        public Result getScriptEnvironmentTableState() {
            return this.scriptEnvironment;
        }

        public Result getSpecimenArchiveTableState() {
            return this.specimenArchive;
        }

        public Result getEventLogTableState() {
            return this.eventlog;
        }

        public Result getRuleURLTableState() {
            return this.ruleURL;
        }

        public Result getHttpDiscoveryTableState() {
            return this.httpDiscovery;
        }

        public Result getHttpSignatureScanResultTableState() {
            return this.httpSignatureScanResult;
        }

        public Result getMatchedRulesTableState() {
            return this.matchedRules;
        }

        public Result getRuleFilterTableState() {
            return this.ruleFilter;
        }

        public Result getHttpDiscoveryResultTable() {
            return this.httpDiscoveryResult;
        }

        public Result getSignatureExceptionsTable() {
            return this.signatureExceptions;
        }

        public Result getServiceScanRuleTable() {
            return this.serviceScanRule;
        }

        public Result getDefinitionErrorsTable() {
            return this.definitionErrors;
        }
    }

    public static enum Result {
        NO_ACTION_NECESSARY,
        UPGRADE_SUCCESS,
        UPGRADE_FAILED,
        TABLE_CREATED,
        TABLE_CREATION_FAILED;

    }
}

