/*
 * Decompiled with CFR 0.152.
 */
package net.lukemurphey.nsia;

import java.net.InetAddress;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Vector;
import net.lukemurphey.nsia.Application;
import net.lukemurphey.nsia.DuplicateEntryException;
import net.lukemurphey.nsia.FirewallRule;
import net.lukemurphey.nsia.HostAddress;
import net.lukemurphey.nsia.InetAddressRange;
import net.lukemurphey.nsia.NoDatabaseConnectionException;
import net.lukemurphey.nsia.NotFoundException;

public class Firewall {
    private Application appRes;
    private Vector<FirewallRule> firewallRules;
    private boolean defaultDeny = true;
    private Mode firewallMode = Mode.RESTRICTED;

    public Firewall(Application applicationResources) {
        if (applicationResources == null) {
            throw new IllegalArgumentException("The application resource cannot be null");
        }
        this.appRes = applicationResources;
    }

    public void setOpenMode() {
        this.firewallMode = Mode.OPEN;
    }

    public void setRestrictedMode() {
        this.firewallMode = Mode.RESTRICTED;
    }

    public void setDefaultDeny(boolean denyByDefault) {
        this.defaultDeny = denyByDefault;
    }

    public boolean getDefaultDeny() {
        return this.defaultDeny;
    }

    public FirewallRule[] getFirewallRules() {
        if (this.firewallRules == null) {
            return null;
        }
        FirewallRule[] firewallRulesArray = new FirewallRule[this.firewallRules.size()];
        int c = 0;
        while (c < this.firewallRules.size()) {
            firewallRulesArray[c] = this.firewallRules.get(c);
            ++c;
        }
        return firewallRulesArray;
    }

    public synchronized void loadFirewallRulesFromDatabase() throws NoDatabaseConnectionException, SQLException {
        Connection connection = null;
        Statement statement = null;
        ResultSet result = null;
        try {
            connection = this.appRes.getDatabaseConnection(Application.DatabaseAccessType.FIREWALL);
            if (connection == null) {
                throw new NoDatabaseConnectionException();
            }
            statement = connection.prepareStatement("Select * from Firewall where RuleState = 1");
            result = statement.executeQuery();
            Vector<FirewallRule> tempFirewallRules = new Vector<FirewallRule>();
            while (result.next()) {
                boolean deny = result.getInt("Action") == 0;
                InetAddressRange addressRange = InetAddressRange.getByRange(new HostAddress(result.getString("IpStart")), new HostAddress(result.getString("IpEnd")));
                FirewallRule firewallRule = result.getTimestamp("ExpirationDate") == null ? new FirewallRule(addressRange, deny, result.getLong("RuleID")) : new FirewallRule(addressRange, deny, result.getLong("RuleID"), result.getTimestamp("ExpirationDate"));
                tempFirewallRules.add(firewallRule);
            }
            this.firewallRules = tempFirewallRules;
        }
        finally {
            if (result != null) {
                result.close();
            }
            if (statement != null) {
                statement.close();
            }
            if (connection != null) {
                connection.close();
            }
        }
    }

    public Mode getFirewallMode() {
        return this.firewallMode;
    }

    public Action isAllowed(HostAddress address) {
        if (address == null) {
            throw new IllegalArgumentException("The IP address must not be null");
        }
        if (InetAddressRange.isAddressLoopback(address)) {
            return Action.ACCEPT;
        }
        if (this.firewallMode == Mode.RESTRICTED) {
            return Action.REJECT;
        }
        if (this.firewallRules == null) {
            if (this.defaultDeny) {
                return Action.REJECTED_BY_DEFAULT;
            }
            return Action.ACCEPTED_BY_DEFAULT;
        }
        for (FirewallRule currentRule : this.firewallRules) {
            FirewallRule.Result status = currentRule.isAccepted(address);
            if (status == FirewallRule.Result.REJECT) {
                return Action.REJECT;
            }
            if (status != FirewallRule.Result.ACCEPT) continue;
            return Action.ACCEPT;
        }
        if (this.defaultDeny) {
            return Action.REJECTED_BY_DEFAULT;
        }
        return Action.ACCEPTED_BY_DEFAULT;
    }

    public FirewallRule[] getMatchingFirewallRules(InetAddress address) {
        if (this.firewallRules == null) {
            return new FirewallRule[0];
        }
        Vector<FirewallRule> matchedRules = new Vector<FirewallRule>();
        for (FirewallRule firewallRule : this.firewallRules) {
            if (firewallRule.isAccepted(address) == FirewallRule.Result.NOT_MATCH) continue;
            matchedRules.add(firewallRule);
        }
        FirewallRule[] firewallRulesArray = new FirewallRule[matchedRules.size()];
        int c = 0;
        while (c < matchedRules.size()) {
            firewallRulesArray[c] = (FirewallRule)matchedRules.get(c);
            ++c;
        }
        return firewallRulesArray;
    }

    public FirewallRule getFirewallRuleById(long ruleId) throws NotFoundException {
        if (this.firewallRules == null) {
            return null;
        }
        for (FirewallRule currentRule : this.firewallRules) {
            if (currentRule.getRuleId() != ruleId) continue;
            return currentRule;
        }
        throw new NotFoundException("No firewall rule exists with the given ID");
    }

    public boolean doesFirewallRuleExist(long ruleId) {
        if (this.firewallRules == null) {
            return false;
        }
        for (FirewallRule currentRule : this.firewallRules) {
            if (currentRule.getRuleId() != ruleId) continue;
            return true;
        }
        return false;
    }

    public boolean removeFirewallRule(long ruleId) throws SQLException, NoDatabaseConnectionException {
        Connection connection = null;
        Statement statement = null;
        try {
            connection = this.appRes.getDatabaseConnection(Application.DatabaseAccessType.FIREWALL);
            statement = connection.prepareStatement("Delete from Firewall where RuleID = ?");
            statement.setLong(1, ruleId);
            statement.executeUpdate();
            boolean ruleFound = false;
            int c = 0;
            while (c < this.firewallRules.size()) {
                FirewallRule firewallRule = this.firewallRules.get(c);
                if (firewallRule.getRuleId() == ruleId) {
                    this.firewallRules.remove(c);
                    ruleFound = true;
                }
                ++c;
            }
            boolean bl = ruleFound;
            return bl;
        }
        finally {
            if (statement != null) {
                statement.close();
            }
            if (connection != null) {
                connection.close();
            }
        }
    }

    public synchronized void addFirewallRule(FirewallRule firewallRule) throws DuplicateEntryException, SQLException, NoDatabaseConnectionException {
        if (firewallRule == null) {
            throw new IllegalArgumentException("The firewall rule cannot be null");
        }
        if (this.doesFirewallRuleExist(firewallRule.getRuleId())) {
            throw new DuplicateEntryException("Firewall rule cannot be added since one already exists with the given identifier (" + firewallRule.getRuleId() + ")");
        }
        Connection connection = null;
        this.firewallRules.add(firewallRule);
        Timestamp expiredate = firewallRule.getRuleExpireTime();
        Statement statement = null;
        try {
            connection = this.appRes.getDatabaseConnection(Application.DatabaseAccessType.FIREWALL);
            statement = expiredate == null ? connection.prepareStatement("Insert into Firewall (IpStart, IpEnd, Action, RuleState) values (?, ?, ?, ?) ") : connection.prepareStatement("Insert into Firewall (IpStart, IpEnd, Action, RuleState, ExpirationDate) values (?, ?, ?, ?, ?) ");
            int action = firewallRule.isDenyRule() ? 0 : 1;
            statement.setString(1, firewallRule.getAddressRange().getStartAddressString());
            statement.setString(2, firewallRule.getAddressRange().getEndAddressString());
            statement.setInt(3, action);
            statement.setInt(4, 1);
            if (expiredate != null) {
                statement.setTimestamp(5, firewallRule.getRuleExpireTime());
            }
        }
        finally {
            if (statement != null) {
                statement.close();
            }
            if (connection != null) {
                connection.close();
            }
        }
    }

    public static enum Action {
        REJECT,
        ACCEPT,
        REJECTED_BY_DEFAULT,
        ACCEPTED_BY_DEFAULT;

    }

    public static enum Mode {
        OPEN,
        RESTRICTED;

    }
}

