/*
 * Decompiled with CFR 0.152.
 */
package net.lukemurphey.nsia;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.reflect.Array;
import java.net.UnknownHostException;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.mail.Authenticator;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.MimeMessage;
import net.lukemurphey.nsia.Application;
import net.lukemurphey.nsia.ApplicationConfiguration;
import net.lukemurphey.nsia.EmailAddress;
import net.lukemurphey.nsia.InputValidationException;
import net.lukemurphey.nsia.InvalidLocalPartException;
import net.lukemurphey.nsia.NoDatabaseConnectionException;

public class GenericUtils {
    public static Object resizeArray(Object oldArray, int newSize) {
        if (newSize < 0) {
            return oldArray;
        }
        int oldSize = Array.getLength(oldArray);
        if (oldSize == newSize) {
            return oldArray;
        }
        Class<?> elementType = oldArray.getClass().getComponentType();
        Object newArray = Array.newInstance(elementType, newSize);
        int preserveLength = Math.min(oldSize, newSize);
        if (preserveLength > 0) {
            System.arraycopy(oldArray, 0, newArray, 0, preserveLength);
        }
        return newArray;
    }

    public static String getTimeDescription(long secs) {
        double doubleSecs = secs;
        DecimalFormat twoPlaces = new DecimalFormat("0.00");
        if (secs < 60L) {
            return String.valueOf(secs) + " sec";
        }
        if (secs < 3600L) {
            return String.valueOf(twoPlaces.format(doubleSecs / 60.0)) + " min";
        }
        if (secs < 86400L) {
            return String.valueOf(twoPlaces.format(doubleSecs / 3600.0)) + " hours";
        }
        return String.valueOf(twoPlaces.format(doubleSecs / 86400.0)) + " days";
    }

    public static String shortenString(String input, int desiredLength) {
        if (input == null || input.length() == 0) {
            return "";
        }
        if (desiredLength < 5) {
            return "";
        }
        if (input.length() <= desiredLength) {
            return input;
        }
        int finalDesiredLength = desiredLength - 4;
        int lastSpace = -1;
        input = input.trim();
        int nextLastSpace = input.indexOf(" ");
        while (nextLastSpace > 0 && nextLastSpace < desiredLength) {
            lastSpace = nextLastSpace;
            nextLastSpace = input.indexOf(" ", nextLastSpace + 1);
        }
        int cutRatio = 100 * finalDesiredLength / lastSpace;
        if (lastSpace < 0) {
            return String.valueOf(input.substring(0, desiredLength)) + "...";
        }
        if (lastSpace < 0 && finalDesiredLength < input.length() || cutRatio < 80) {
            return String.valueOf(input.substring(0, finalDesiredLength)) + " ...";
        }
        return String.valueOf(input.substring(0, lastSpace)) + " ...";
    }

    public static void zipDir(File zipDir, ZipOutputStream zos) throws IOException {
        String[] dirList = zipDir.isDirectory() ? zipDir.list() : new String[]{zipDir.getAbsolutePath()};
        byte[] readBuffer = new byte[2156];
        int bytesIn = 0;
        int i = 0;
        while (i < dirList.length) {
            File f = new File(zipDir, dirList[i]);
            if (f.isDirectory()) {
                GenericUtils.zipDir(f, zos);
            } else {
                FileInputStream fis = new FileInputStream(f);
                ZipEntry anEntry = new ZipEntry(f.getPath());
                zos.putNextEntry(anEntry);
                while ((bytesIn = fis.read(readBuffer)) != -1) {
                    zos.write(readBuffer, 0, bytesIn);
                }
                fis.close();
            }
            ++i;
        }
    }

    public static boolean deleteDirectory(File path) {
        if (path.exists()) {
            File[] files = path.listFiles();
            int i = 0;
            while (i < files.length) {
                if (files[i].isDirectory()) {
                    GenericUtils.deleteDirectory(files[i]);
                } else {
                    files[i].delete();
                }
                ++i;
            }
        }
        return path.delete();
    }

    public static int twoStateProgress(int expectedMaxTime, int startTime) {
        int third;
        int currentTime = (int)System.currentTimeMillis();
        int diff = currentTime - startTime;
        if (diff <= (third = expectedMaxTime / 3)) {
            return 100 * diff / third / 2;
        }
        if (diff > expectedMaxTime) {
            return 100;
        }
        return 50 + 100 * (diff - third) / (expectedMaxTime - third) / 2;
    }

    public static boolean sendMail(EmailAddress toAddress, String subject, String body) throws MessagingException {
        Application app = Application.getApplication();
        ApplicationConfiguration config = app.getApplicationConfiguration();
        try {
            return GenericUtils.sendMail(toAddress, subject, body, config.getEmailFromAddress(), config.getEmailSMTPServer(), config.getEmailUsername(), config.getEmailPassword(), config.getEmailSMTPPort(), config.getEmailSMTPEncryption());
        }
        catch (UnknownHostException e) {
            throw new MessagingException("Host is unknown", (Exception)e);
        }
        catch (NoDatabaseConnectionException e) {
            throw new MessagingException("No database connection", (Exception)e);
        }
        catch (SQLException e) {
            throw new MessagingException("SQL exception", (Exception)e);
        }
        catch (InputValidationException e) {
            throw new MessagingException("Input validation exception", (Exception)e);
        }
        catch (InvalidLocalPartException e) {
            throw new MessagingException("Local part of email is invalid", (Exception)e);
        }
    }

    public static boolean sendMail(EmailAddress toAddress, String subject, String body, EmailAddress fromAddress, String smtpServer, String username, String password, int port, SMTPEncryption encryption) throws MessagingException {
        if (smtpServer == null || fromAddress == null) {
            return false;
        }
        Properties props = new Properties();
        props.put("mail.smtp.host", smtpServer);
        props.put("mail.from", fromAddress.toString());
        props.put("mail.smtp.port", Integer.toString(port));
        if (username != null) {
            props.put("mail.smtp.auth", "true");
        }
        if (encryption == SMTPEncryption.STARTTLS) {
            props.put("mail.smtp.starttls.enable", "true");
        } else if (encryption == SMTPEncryption.SSL) {
            props.put("mail.smtp.ssl", "true");
        }
        Session session = null;
        if (encryption == SMTPEncryption.SSL || encryption == SMTPEncryption.STARTTLS || encryption == SMTPEncryption.TLS) {
            props.put("mail.smtp.socketFactory.class", "javax.net.ssl.SSLSocketFactory");
            props.put("mail.smtp.socketFactory.fallback", "false");
            props.put("mail.smtp.socketFactory.port", Integer.toString(port));
            props.setProperty("mail.smtp.quitwait", "false");
            System.getSecurityManager();
            SMTPAuthenticator auth = new SMTPAuthenticator(username, password);
            session = Session.getInstance((Properties)props, (Authenticator)auth);
        } else {
            session = Session.getInstance((Properties)props, null);
        }
        MimeMessage msg = new MimeMessage(session);
        msg.setFrom();
        msg.setRecipients(Message.RecipientType.TO, toAddress.toString());
        msg.setSubject(subject);
        msg.setSentDate(new Date());
        msg.setText(body);
        Transport transport = session.getTransport("smtp");
        if (username != null) {
            transport.connect(smtpServer, username, password);
        }
        if (!transport.isConnected()) {
            throw new MessagingException("Connection to the mail server failed");
        }
        transport.sendMessage((Message)msg, msg.getAllRecipients());
        transport.close();
        return true;
    }

    public static Date addOrSubstractDaysFromDate(Date aDate, int noOfDays) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(aDate);
        calendar.add(5, noOfDays);
        return calendar.getTime();
    }

    private static class SMTPAuthenticator
    extends Authenticator {
        private String username;
        private String password;

        public SMTPAuthenticator(String username, String password) {
            this.username = username;
            this.password = password;
        }

        public PasswordAuthentication getPasswordAuthentication() {
            return new PasswordAuthentication(this.username, this.password);
        }
    }

    public static enum SMTPEncryption {
        NONE,
        SSL,
        STARTTLS,
        TLS;

    }
}

