/*
 * Decompiled with CFR 0.152.
 */
package net.lukemurphey.nsia;

import java.sql.SQLException;
import net.lukemurphey.nsia.GroupManagement;
import net.lukemurphey.nsia.InputValidationException;
import net.lukemurphey.nsia.NoDatabaseConnectionException;

public class GroupMembershipDescriptor {
    GroupManagement.GroupDescriptor[] groupDescriptors;
    boolean[] isMember;
    int userId;

    public GroupMembershipDescriptor(GroupManagement.GroupDescriptor[] groupDesc, boolean[] membershipMatrix, int userId) {
        if (membershipMatrix.length != groupDesc.length) {
            throw new IllegalArgumentException("The length of the membership matrix is not equal to number of group descriptors");
        }
        this.userId = userId;
        this.groupDescriptors = new GroupManagement.GroupDescriptor[groupDesc.length];
        this.isMember = new boolean[membershipMatrix.length];
        System.arraycopy(groupDesc, 0, this.groupDescriptors, 0, groupDesc.length);
        System.arraycopy(this.isMember, 0, membershipMatrix, 0, membershipMatrix.length);
    }

    public GroupMembershipDescriptor(int userId, GroupManagement groupManager) throws SQLException, InputValidationException, NoDatabaseConnectionException {
        this.groupDescriptors = groupManager.getGroupDescriptors();
        this.isMember = new boolean[this.groupDescriptors.length];
        int c = 0;
        while (c < this.isMember.length) {
            this.isMember[c] = false;
            ++c;
        }
        c = 0;
        while (c < this.isMember.length) {
            this.isMember[c] = groupManager.isUserMemberOfGroup(userId, this.groupDescriptors[c].getGroupId());
            ++c;
        }
    }

    public int getSize() {
        return this.isMember.length;
    }

    public boolean isMemberOfGroup(GroupManagement.GroupDescriptor group) {
        return this.isMemberOfGroupByID(group.getGroupId());
    }

    public boolean isMemberOfGroupByID(int groupId) {
        if (this.isMember == null) {
            return false;
        }
        int c = 0;
        while (c < this.isMember.length) {
            if (this.groupDescriptors[c].getGroupId() == groupId) {
                return this.isMember[c];
            }
            ++c;
        }
        return false;
    }

    public int getUserId() {
        return this.userId;
    }

    public GroupManagement.GroupDescriptor[] getGroupDescriptors() {
        GroupManagement.GroupDescriptor[] groupDescriptorsCopy = new GroupManagement.GroupDescriptor[this.groupDescriptors.length];
        System.arraycopy(this.groupDescriptors, 0, groupDescriptorsCopy, 0, this.groupDescriptors.length);
        return groupDescriptorsCopy;
    }

    public GroupManagement.GroupDescriptor getGroupDescriptorByID(int groupId) {
        if (this.isMember == null) {
            return null;
        }
        int c = 0;
        while (c < this.isMember.length) {
            if (this.groupDescriptors[c].getGroupId() == groupId) {
                return this.groupDescriptors[c];
            }
            ++c;
        }
        return null;
    }

    public GroupManagement.GroupDescriptor getGroupDescriptor(int c) {
        if (this.groupDescriptors != null && c < this.groupDescriptors.length) {
            return this.groupDescriptors[c];
        }
        return null;
    }

    public boolean isMemberOfGroup(int c) {
        if (this.isMember != null && c < this.isMember.length) {
            return this.isMember[c];
        }
        return false;
    }

    public boolean isGroupInList(int groupId) {
        if (this.isMember == null) {
            return false;
        }
        int c = 0;
        while (c < this.isMember.length) {
            if (this.groupDescriptors[c].getGroupId() == groupId) {
                return true;
            }
            ++c;
        }
        return false;
    }
}

