/*
 * Decompiled with CFR 0.152.
 */
package net.lukemurphey.nsia;

import java.io.Serializable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class HostAddress
implements Serializable {
    private static final long serialVersionUID = -5963080860620191754L;
    private static final String VALID_HOSTNAME_REGEX = "[-0-9_.A-Za-z]+";
    private static final String VALID_IP_ADDRESS = "(?:(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.){3}(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)";
    private int type = -1;
    private String value = null;
    public static final int IP_ADDRESS = 0;
    public static final int DOMAIN_NAME = 2;

    public HostAddress(String name) {
        Pattern domainNameRegex;
        Pattern ipAddressRegex = Pattern.compile(VALID_IP_ADDRESS);
        Matcher matcher = ipAddressRegex.matcher(name);
        if (matcher.matches()) {
            this.type = 0;
            this.value = name;
        }
        if ((matcher = (domainNameRegex = Pattern.compile(VALID_HOSTNAME_REGEX)).matcher(name)).matches()) {
            this.type = 2;
            this.value = name;
        }
        if (this.type == -1) {
            throw new IllegalArgumentException("The name given is not a valid IP address or hostname");
        }
    }

    public int addressType() {
        return this.type;
    }

    public String toString() {
        return this.value;
    }
}

