/*
 * Decompiled with CFR 0.152.
 */
package net.lukemurphey.nsia;

import java.util.Date;

public class LicenseDescriptor {
    private String licensee;
    private String licenseKey;
    private Date expires;
    private Type licenseType;
    private LicenseStatus status;
    private Boolean expired = null;

    private LicenseDescriptor() {
    }

    protected LicenseDescriptor(LicenseStatus status) {
        this.expires = null;
        this.licensee = null;
        this.licenseKey = null;
        this.licenseType = null;
        this.status = status;
    }

    public LicenseDescriptor(String licensee, String licenseKey, Date expires, Type licenseType, LicenseStatus status) {
        this.expires = expires;
        this.licensee = licensee;
        this.licenseKey = licenseKey;
        this.licenseType = licenseType;
        this.status = status;
    }

    public LicenseDescriptor(String licensee, String licenseKey, Date expires, Type licenseType, LicenseStatus status, boolean expired) {
        this.expires = expires;
        this.licensee = licensee;
        this.licenseKey = licenseKey;
        this.licenseType = licenseType;
        this.status = status;
        this.expired = expired;
    }

    public static LicenseDescriptor uncheckedLicense(String licenseKey) {
        LicenseDescriptor desc = new LicenseDescriptor();
        desc.expires = null;
        desc.licensee = null;
        desc.licenseKey = licenseKey;
        desc.licenseType = null;
        desc.status = LicenseStatus.UNVALIDATED;
        desc.isValid();
        return desc;
    }

    public String getKey() {
        return this.licenseKey;
    }

    public Date getExpirationDate() {
        if (this.expires != null) {
            return (Date)this.expires.clone();
        }
        return null;
    }

    public Type getType() {
        return this.licenseType;
    }

    public LicenseStatus getStatus() {
        return this.status;
    }

    public String getLicensee() {
        return this.licensee;
    }

    public boolean isValid() {
        if (this.getStatus() != LicenseStatus.ACTIVE) {
            return false;
        }
        if (this.expired.booleanValue() || this.expired == null && this.getExpirationDate().before(new Date())) {
            this.status = LicenseStatus.EXPIRED;
            return false;
        }
        return true;
    }

    public static enum LicenseStatus {
        EXPIRED("Expired"),
        DISABLED("Disabled"),
        ILLEGAL("Illegal Key"),
        UNLICENSED("Unlicensed"),
        DEMO("Demo License"),
        ACTIVE("Active"),
        UNVALIDATED("Unvalidated");

        private String description;

        private LicenseStatus(String description) {
            this.description = description;
        }

        public String getDescription() {
            return this.description;
        }
    }

    public static enum Type {
        DEMO,
        STANDARD,
        PARTNER,
        NON_PROFIT,
        BETA_TEST,
        UNDEFINED,
        FREE;

    }
}

