/*
 * Decompiled with CFR 0.152.
 */
package net.lukemurphey.nsia;

import java.sql.SQLException;
import java.util.regex.Pattern;
import net.lukemurphey.nsia.Application;
import net.lukemurphey.nsia.InputValidationException;
import net.lukemurphey.nsia.LicenseDescriptor;
import net.lukemurphey.nsia.LicenseValidationException;
import net.lukemurphey.nsia.NoDatabaseConnectionException;
import net.lukemurphey.nsia.eventlog.EventLogField;
import net.lukemurphey.nsia.eventlog.EventLogMessage;
import net.lukemurphey.nsia.rest.LicenseInfo;
import net.lukemurphey.nsia.rest.RESTRequestFailedException;

public class LicenseManagement {
    private static final Pattern LICENSE_KEY_REGEX = Pattern.compile("[a-zA-Z0-9]{4,4}(-?[a-zA-Z0-9]{4,4}){4,4}");
    public static final String LICENSE_DATE_FORMAT = "yyyy-MM-dd HH:mm:ss";

    private LicenseManagement() {
    }

    public static boolean validateLicenseKey(String key) throws LicenseValidationException, InputValidationException {
        LicenseDescriptor licenseKey = LicenseManagement.getKeyInfo(key);
        return licenseKey.isValid();
    }

    public static LicenseDescriptor getKeyInfo(String key) throws LicenseValidationException, InputValidationException {
        if (key == null) {
            return new LicenseDescriptor(LicenseDescriptor.LicenseStatus.UNLICENSED);
        }
        if (!LICENSE_KEY_REGEX.matcher(key).matches()) {
            throw new InputValidationException("The license key is not a valid key", "LicenseKey", key);
        }
        String uniqueInstallID = null;
        try {
            Application.getApplication().getApplicationConfiguration().getUniqueInstallationID();
        }
        catch (InputValidationException e) {
            uniqueInstallID = "";
            Application.getApplication().logExceptionEvent(new EventLogMessage(EventLogMessage.EventType.INTERNAL_ERROR, new EventLogField(EventLogField.FieldName.MESSAGE, "Unable to get unique installation identifier")), (Throwable)e);
        }
        catch (NoDatabaseConnectionException e) {
            uniqueInstallID = "";
            Application.getApplication().logExceptionEvent(new EventLogMessage(EventLogMessage.EventType.INTERNAL_ERROR, new EventLogField(EventLogField.FieldName.MESSAGE, "Unable to get unique installation identifier")), (Throwable)e);
        }
        catch (SQLException e) {
            uniqueInstallID = "";
            Application.getApplication().logExceptionEvent(new EventLogMessage(EventLogMessage.EventType.INTERNAL_ERROR, new EventLogField(EventLogField.FieldName.MESSAGE, "Unable to get unique installation identifier")), (Throwable)e);
        }
        try {
            LicenseInfo licenseInfo = new LicenseInfo(uniqueInstallID, key);
            return licenseInfo.getLicenseInformation();
        }
        catch (RESTRequestFailedException e) {
            throw new LicenseValidationException("Unable to get information about the license");
        }
    }
}

