/*
 * Decompiled with CFR 0.152.
 */
package net.lukemurphey.nsia;

import java.net.BindException;
import net.lukemurphey.nsia.Application;
import net.lukemurphey.nsia.UserManagement;
import net.lukemurphey.nsia.scan.DefinitionArchive;
import net.lukemurphey.nsia.tools.AppLaunch;
import org.mortbay.util.MultiException;

public class Main {
    public static final void main(String[] args) {
        Application.RunMode runMode = Application.RunMode.CLI;
        String[] stringArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            String arg = stringArray[n2];
            if ("-gui".equalsIgnoreCase(arg) || "--gui".equalsIgnoreCase(arg) || "-g".equalsIgnoreCase(arg)) {
                runMode = Application.RunMode.GUI;
            }
            if ("-s".equalsIgnoreCase(arg) || "-service".equalsIgnoreCase(arg) || "--service".equalsIgnoreCase(arg)) {
                runMode = Application.RunMode.SERVICE;
            }
            ++n2;
        }
        if (args != null && args.length == 4 && args[0].equalsIgnoreCase("--install")) {
            try {
                Application app = Application.startApplication(null, Application.RunMode.CLI, false);
                System.out.println("Completing installation");
                if (Main.completeInstall(args[1], args[3], args[2], app)) {
                    app.shutdown(false);
                    System.exit(0);
                } else {
                    app.shutdown(false);
                    System.exit(-1);
                }
            }
            catch (Exception e) {
                System.err.println("Fatal Exception, application terminating (Stack Trace Follows)");
                e.printStackTrace();
                System.exit(-1);
            }
        }
        if (runMode == Application.RunMode.GUI) {
            AppLaunch.main(args);
        } else {
            try {
                Application.startApplication(args, runMode);
            }
            catch (MultiException e) {
                if (e.getException(0).getClass() == BindException.class) {
                    System.err.println("Port could not be opened, application terminating");
                    System.exit(-1);
                } else {
                    System.err.println("Fatal Exception, application terminating (Stack Trace Follows)");
                    e.printStackTrace();
                    System.exit(-1);
                }
            }
            catch (Exception e) {
                System.err.println("Fatal Exception, application terminating (Stack Trace Follows)");
                e.printStackTrace();
                System.exit(-1);
            }
        }
    }

    private static boolean completeInstall(String username, String password, String realName, Application app) {
        UserManagement userManagement = new UserManagement(app);
        int errors = 0;
        try {
            if (userManagement.addAccount(username, realName, password, "SHA-512", 10000L, null, true) < 0) {
                ++errors;
            }
            DefinitionArchive archive = DefinitionArchive.getArchive();
            archive.loadDefaultDefinitions();
            return errors == 0;
        }
        catch (Exception e) {
            return false;
        }
    }
}

