/*
 * Decompiled with CFR 0.152.
 */
package net.lukemurphey.nsia;

import eu.medsea.util.MimeUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import javax.activation.MimetypesFileTypeMap;
import net.lukemurphey.nsia.Application;
import net.lukemurphey.nsia.eventlog.EventLogField;
import net.lukemurphey.nsia.eventlog.EventLogMessage;

public class MimeType {
    private static MimetypesFileTypeMap typeMap = null;

    private static MimetypesFileTypeMap getMimeTypeMap() {
        if (typeMap == null) {
            String fileName = "../etc/mime.types";
            try {
                File file = new File(fileName);
                if (file.exists()) {
                    typeMap = new MimetypesFileTypeMap(fileName);
                }
            }
            catch (IOException e) {
                EventLogMessage message = new EventLogMessage(EventLogMessage.EventType.INTERNAL_ERROR);
                message.addField(new EventLogField(EventLogField.FieldName.MESSAGE, "Unable to load mime-types file"));
                message.addField(new EventLogField(EventLogField.FieldName.FILE, fileName));
                Application.getApplication().logExceptionEvent(message, (Throwable)e);
            }
            InputStream in = null;
            if (typeMap == null) {
                try {
                    in = MimeType.class.getResourceAsStream("mime.types");
                    typeMap = new MimetypesFileTypeMap(in);
                }
                finally {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException e) {
                            EventLogMessage message = new EventLogMessage(EventLogMessage.EventType.INTERNAL_ERROR);
                            message.addField(new EventLogField(EventLogField.FieldName.MESSAGE, "Unable to load embedded mime.types file"));
                            Application.getApplication().logExceptionEvent(message, (Throwable)e);
                        }
                    }
                }
            }
        }
        return typeMap;
    }

    public static String getMimeTypeFromName(String filename) {
        if (filename == null) {
            return null;
        }
        int index = filename.lastIndexOf(".");
        if (index < 0) {
            return null;
        }
        return MimeType.getMimeTypeMap().getContentType(filename);
    }

    private static String filterLookupFailure(String contentType) {
        if (contentType == null || contentType.equalsIgnoreCase("application/x-unknown-mime-type")) {
            return null;
        }
        return contentType;
    }

    public static String getMimeType(File file) {
        String mimeType = MimeUtil.getMimeType((File)file);
        if (mimeType == null || mimeType.equalsIgnoreCase("application/x-unknown-mime-type")) {
            return MimeType.getMimeTypeFromName(file.getName());
        }
        return mimeType;
    }

    public static String getMimeType(byte[] content) {
        if (content == null || content.length == 0) {
            return null;
        }
        String mimeType = MimeUtil.getMimeType((byte[])content);
        return MimeType.filterLookupFailure(mimeType);
    }

    public static String getMimeType(byte[] content, String filename) {
        String mimeType = null;
        if (content != null && content.length > 0) {
            mimeType = MimeUtil.getMimeType((byte[])content);
        }
        if ((mimeType = MimeType.filterLookupFailure(mimeType)) == null) {
            return MimeType.getMimeTypeFromName(filename);
        }
        return mimeType;
    }

    public static String getMimeType(byte[] content, String filename, String defaultMimeType) {
        String mimeType = null;
        if (content != null && content.length > 0) {
            mimeType = MimeUtil.getMimeType((byte[])content);
        }
        if ((mimeType = MimeType.filterLookupFailure(mimeType)) == null) {
            mimeType = MimeType.getMimeTypeFromName(filename);
            if ("application/octet-stream".equalsIgnoreCase(mimeType)) {
                return defaultMimeType;
            }
            return mimeType;
        }
        return mimeType;
    }
}

