/*
 * Decompiled with CFR 0.152.
 */
package net.lukemurphey.nsia;

import java.sql.SQLException;
import net.lukemurphey.nsia.Application;
import net.lukemurphey.nsia.ApplicationStateMonitor;
import net.lukemurphey.nsia.InputValidationException;
import net.lukemurphey.nsia.NoDatabaseConnectionException;
import net.lukemurphey.nsia.NotFoundException;
import net.lukemurphey.nsia.SiteGroupManagement;
import net.lukemurphey.nsia.eventlog.EventLogField;
import net.lukemurphey.nsia.eventlog.EventLogMessage;
import net.lukemurphey.nsia.scan.ScanResultCode;
import net.lukemurphey.nsia.scan.ScanRule;

public class ScanCallback {
    private ApplicationStateMonitor monitor = null;
    private Application application = null;

    public ScanCallback(Application application) {
        if (application == null) {
            throw new IllegalArgumentException("The application cannot be null");
        }
        this.monitor = application.getApplicationStateMonitor();
        if (this.monitor == null) {
            throw new IllegalArgumentException("The application state monitor cannot be null");
        }
        this.application = application;
    }

    public void logScanResult(ScanResultCode resultCode, int deviations, String ruleType, String specimen, long scanRuleID) {
        this.logScanResult(resultCode, deviations, ruleType, specimen, null, scanRuleID, true);
    }

    public void logScanResult(ScanResultCode resultCode, int deviations, String ruleType, String specimen, String message, long scanRuleID) {
        this.logScanResult(resultCode, deviations, ruleType, specimen, message, scanRuleID, true);
    }

    public void logScanResult(ScanResultCode resultCode, int deviations, String ruleType, String specimen, long scanRuleID, boolean sendToEventLog) {
        this.logScanResult(resultCode, deviations, ruleType, specimen, null, scanRuleID, sendToEventLog);
    }

    public void logScanResult(ScanResultCode resultCode, int deviations, String ruleType, String specimen, String message, long scanRuleID, boolean sendToEventLog, boolean noteScanCompleted) {
        this.logScanResult(resultCode, deviations, ruleType, specimen, message, scanRuleID, sendToEventLog, noteScanCompleted, false);
    }

    public void logScanResult(ScanResultCode resultCode, int deviations, String ruleType, String specimen, String message, long scanRuleID, boolean sendToEventLog, boolean noteScanCompleted, boolean ruleCompleted) {
        if (sendToEventLog) {
            EventLogMessage logMessage = deviations > 0 ? (ruleCompleted ? new EventLogMessage(EventLogMessage.EventType.RULE_COMPLETE_REJECTED) : new EventLogMessage(EventLogMessage.EventType.RULE_REJECTED)) : (resultCode == ScanResultCode.SCAN_FAILED || resultCode == ScanResultCode.UNREADY ? (ruleCompleted ? new EventLogMessage(EventLogMessage.EventType.RULE_COMPLETE_FAILED) : new EventLogMessage(EventLogMessage.EventType.RULE_FAILED)) : (ruleCompleted ? new EventLogMessage(EventLogMessage.EventType.RULE_COMPLETE_ACCEPTED) : new EventLogMessage(EventLogMessage.EventType.RULE_ACCEPTED)));
            if (message != null) {
                logMessage.addField(new EventLogField(EventLogField.FieldName.MESSAGE, message));
            }
            if (specimen != null) {
                logMessage.addField(new EventLogField(EventLogField.FieldName.RULE_SPECIMEN, specimen));
            }
            int siteGroupID = -1;
            try {
                siteGroupID = ScanRule.getSiteGroupForRule(scanRuleID);
                if (siteGroupID >= 0) {
                    logMessage.addField(new EventLogField(EventLogField.FieldName.SITE_GROUP_ID, siteGroupID));
                    SiteGroupManagement siteGroupManagement = new SiteGroupManagement(this.application);
                    SiteGroupManagement.SiteGroupDescriptor siteGroup = siteGroupManagement.getGroupDescriptor(siteGroupID);
                    if (siteGroup != null) {
                        logMessage.addField(new EventLogField(EventLogField.FieldName.SITE_GROUP_NAME, siteGroup.getGroupName()));
                    }
                }
            }
            catch (SQLException e) {
                this.application.logExceptionEvent(new EventLogMessage(EventLogMessage.EventType.SQL_EXCEPTION), (Throwable)e);
            }
            catch (NoDatabaseConnectionException e) {
                this.application.logExceptionEvent(new EventLogMessage(EventLogMessage.EventType.SQL_EXCEPTION), (Throwable)e);
            }
            catch (InputValidationException e) {
                this.application.logExceptionEvent(new EventLogMessage(EventLogMessage.EventType.INTERNAL_ERROR, new EventLogField(EventLogField.FieldName.MESSAGE, "Unable to get the site-group name when creating a message")), (Throwable)e);
            }
            catch (NotFoundException e) {
                this.application.logExceptionEvent(new EventLogMessage(EventLogMessage.EventType.INTERNAL_ERROR, new EventLogField(EventLogField.FieldName.MESSAGE, "Unable to get the site-group name when creating a message")), (Throwable)e);
            }
            logMessage.addField(new EventLogField(EventLogField.FieldName.RULE_TYPE, ruleType));
            logMessage.addField(new EventLogField(EventLogField.FieldName.RULE_ID, scanRuleID));
            logMessage.addField(new EventLogField(EventLogField.FieldName.DEVIATIONS, deviations));
            this.application.logEvent(logMessage);
        }
        if (noteScanCompleted) {
            if (deviations > 0) {
                this.monitor.incrementFailedRulesCount();
            } else if (resultCode == ScanResultCode.SCAN_FAILED || resultCode == ScanResultCode.UNREADY) {
                this.monitor.incrementIncompleteRulesCount();
            } else {
                this.monitor.incrementPassedRulesCount();
            }
        }
    }

    public void logScanResult(ScanResultCode resultCode, int deviations, String ruleType, String specimen, String message, long scanRuleID, boolean sendToEventLog) {
        this.logScanResult(resultCode, deviations, ruleType, specimen, message, scanRuleID, sendToEventLog, true);
    }
}

