/*
 * Decompiled with CFR 0.152.
 */
package net.lukemurphey.nsia;

import java.sql.Connection;
import java.sql.SQLException;
import net.lukemurphey.nsia.Application;
import net.lukemurphey.nsia.NoDatabaseConnectionException;
import net.lukemurphey.nsia.ScanCallback;
import net.lukemurphey.nsia.eventlog.EventLogMessage;
import net.lukemurphey.nsia.scan.ScanResult;
import net.lukemurphey.nsia.scan.ScanRule;
import net.lukemurphey.nsia.scan.ScanRuleLoader;

public class Scanner
extends Thread {
    long ruleId;
    Application appRes;
    ScanRule scan;
    ScanResult scanResult;

    public Scanner(Application applicationResources) {
        if (applicationResources == null) {
            throw new IllegalArgumentException("Application resource cannot be null");
        }
        this.appRes = applicationResources;
    }

    public boolean prepareScan(long ruleId) throws SQLException, Exception {
        this.scan = ScanRuleLoader.getScanRule(ruleId);
        if (this.scan == null) {
            return false;
        }
        this.ruleId = ruleId;
        this.setName(this.scan.toString());
        return true;
    }

    @Override
    public void run() {
        if (this.ruleId < 1L) {
            return;
        }
        Connection connection = null;
        try {
            try {
                this.scanResult = this.doScan();
                connection = this.appRes.getDatabaseConnection(Application.DatabaseAccessType.SCANNER);
                this.scanResult.saveToDatabase(connection, this.ruleId);
            }
            catch (SQLException e) {
                Application.getApplication().logExceptionEvent(EventLogMessage.EventType.SQL_EXCEPTION, (Throwable)e);
                try {
                    if (connection != null) {
                        connection.close();
                    }
                }
                catch (Exception exception) {}
            }
            catch (Exception e) {
                Application.getApplication().logExceptionEvent(EventLogMessage.EventType.INTERNAL_ERROR, (Throwable)e);
                try {
                    if (connection != null) {
                        connection.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
        finally {
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public ScanResult doScan() throws SQLException, Exception {
        if (this.ruleId < 1L) {
            return null;
        }
        ScanCallback callback = new ScanCallback(this.appRes);
        this.scan.setCallback(callback);
        ScanResult result = this.scan.doScan();
        return result;
    }

    public long getRuleId() {
        return this.ruleId;
    }

    public void saveScanResults() throws SQLException, NoDatabaseConnectionException {
        if (this.scanResult == null) {
            throw new IllegalStateException("Scan results do not exist");
        }
        Connection connection = this.appRes.getDatabaseConnection(Application.DatabaseAccessType.SCANNER);
        if (connection == null) {
            throw new NoDatabaseConnectionException();
        }
        try {
            this.scanResult.saveToDatabase(connection, this.ruleId);
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
    }
}

