/*
 * Decompiled with CFR 0.152.
 */
package net.lukemurphey.nsia;

import java.util.Hashtable;

public class SessionStatus {
    public static final SessionStatus SESSION_NULL = new SessionStatus(0, "No session exists");
    public static final SessionStatus SESSION_ACTIVE = new SessionStatus(1, "The session is active");
    public static final SessionStatus SESSION_EXPIRED = new SessionStatus(2, "The session has expired");
    public static final SessionStatus SESSION_IDENTIFIER_EXPIRED = new SessionStatus(3, "The session identifier has expired");
    public static final SessionStatus SESSION_HIJACKED = new SessionStatus(4, "A session hijack attempt was detected for this session");
    public static final SessionStatus SESSION_ADMIN_TERMINATED = new SessionStatus(5, "This session has been explicitly terminated");
    public static final SessionStatus SESSION_LIFETIME_EXCEEDED = new SessionStatus(6, "The session has exceeded its maximum lifetime");
    public static final SessionStatus SESSION_INACTIVE = new SessionStatus(7, "The session was inactive for too long");
    private int statusId = 0;
    private String description = null;

    private SessionStatus(int statInt, String desc) {
        this.statusId = statInt;
        this.description = desc;
    }

    public String getDescription() {
        return this.description;
    }

    public int getStatusId() {
        return this.statusId;
    }

    public String toString() {
        return this.description;
    }

    public boolean equals(Object sessionStatus) {
        if (sessionStatus == null) {
            return false;
        }
        if (sessionStatus instanceof SessionStatus) {
            return ((SessionStatus)sessionStatus).getStatusId() == this.statusId;
        }
        return false;
    }

    public int hashCode() {
        return this.statusId;
    }

    public static SessionStatus getStatusById(int statusId) {
        if (statusId == SESSION_ACTIVE.getStatusId()) {
            return SESSION_ACTIVE;
        }
        if (statusId == SESSION_ADMIN_TERMINATED.getStatusId()) {
            return SESSION_ADMIN_TERMINATED;
        }
        if (statusId == SESSION_EXPIRED.getStatusId()) {
            return SESSION_EXPIRED;
        }
        if (statusId == SESSION_HIJACKED.getStatusId()) {
            return SESSION_HIJACKED;
        }
        if (statusId == SESSION_IDENTIFIER_EXPIRED.getStatusId()) {
            return SESSION_IDENTIFIER_EXPIRED;
        }
        if (statusId == SESSION_INACTIVE.getStatusId()) {
            return SESSION_INACTIVE;
        }
        if (statusId == SESSION_LIFETIME_EXCEEDED.getStatusId()) {
            return SESSION_LIFETIME_EXCEEDED;
        }
        return SESSION_NULL;
    }

    public Hashtable<String, Object> toHashtable() {
        Hashtable<String, Object> hash = new Hashtable<String, Object>();
        hash.put("StatusId", this.statusId);
        hash.put("Description", this.description);
        return hash;
    }
}

