/*
 * Decompiled with CFR 0.152.
 */
package net.lukemurphey.nsia;

import java.sql.Timestamp;
import java.util.Hashtable;
import net.lukemurphey.nsia.SiteGroupManagement;
import net.lukemurphey.nsia.scan.ScanResult;
import net.lukemurphey.nsia.scan.ScanResultCode;

public class SiteGroupScanResult {
    protected ScanResultCode resultCode = null;
    protected SiteGroupManagement.SiteGroupDescriptor siteGroupDescriptor;
    protected ScanResult[] scanResults;
    protected int deviationCount = 0;
    protected int deviatingRules = 0;
    protected int incompleteRules = 0;
    protected Timestamp endScanTime;
    protected Timestamp startScanTime;
    protected long siteGroupId;

    public SiteGroupScanResult(long siteGroupId, SiteGroupManagement.SiteGroupDescriptor descriptor, ScanResult[] results) {
        int c = 0;
        while (c < results.length) {
            if (results[c] != null) {
                if (results[c].getDeviations() > 0) {
                    if (results[c].getResultCode() == null || !results[c].getResultCode().equals(ScanResultCode.SCAN_COMPLETED)) {
                        ++this.incompleteRules;
                    }
                    this.deviationCount += results[c].getDeviations();
                    ++this.deviatingRules;
                }
                this.resultCode = ScanResultCode.SCAN_COMPLETED;
                if (results[c].getResultCode() == null || !results[c].getResultCode().equals(ScanResultCode.SCAN_COMPLETED)) {
                    this.resultCode = ScanResultCode.SCAN_FAILED;
                    ++this.incompleteRules;
                }
            }
            ++c;
        }
        this.siteGroupDescriptor = descriptor;
        this.scanResults = new ScanResult[results.length];
        System.arraycopy(results, 0, this.scanResults, 0, results.length);
        this.siteGroupId = siteGroupId;
    }

    public SiteGroupManagement.SiteGroupDescriptor getSiteGroupDescriptor() {
        return this.siteGroupDescriptor;
    }

    public ScanResult[] getScanResults() {
        ScanResult[] scanResultsCopy = new ScanResult[this.scanResults.length];
        System.arraycopy(this.scanResults, 0, scanResultsCopy, 0, this.scanResults.length);
        return scanResultsCopy;
    }

    public int getDeviations() {
        return this.deviationCount;
    }

    public int getDeviatingRules() {
        return this.deviatingRules;
    }

    public int getIncompleteRules() {
        return this.incompleteRules;
    }

    public Timestamp getStartScanTime() {
        return this.startScanTime;
    }

    public Timestamp getEndScanTime() {
        return this.endScanTime;
    }

    public ScanResultCode getResultCode() {
        return this.resultCode;
    }

    public Hashtable<String, Object> toHashtable() {
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        hashtable.put("SiteGroupID", Double.valueOf(this.siteGroupId));
        hashtable.put("SiteGroupResultCode", this.getResultCode().getId());
        hashtable.put("IncompleteRuleScans", this.incompleteRules);
        if (this.startScanTime != null) {
            hashtable.put("StartScanTime", Double.valueOf(this.startScanTime.getTime()));
        }
        if (this.endScanTime != null) {
            hashtable.put("EndScanTime", Double.valueOf(this.endScanTime.getTime()));
        }
        hashtable.put("Deviations", this.deviationCount);
        hashtable.put("DeviatingRules", this.deviatingRules);
        hashtable.put("SiteGroupDescriptor", this.siteGroupDescriptor.toHashtable());
        return hashtable;
    }

    public long getSiteGroupId() {
        return this.siteGroupId;
    }
}

