/*
 * Decompiled with CFR 0.152.
 */
package net.lukemurphey.nsia;

import java.net.UnknownHostException;
import java.security.NoSuchAlgorithmException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.lukemurphey.nsia.Application;
import net.lukemurphey.nsia.EmailAddress;
import net.lukemurphey.nsia.InputValidationException;
import net.lukemurphey.nsia.InvalidLocalPartException;
import net.lukemurphey.nsia.LocalPasswordAuthentication;
import net.lukemurphey.nsia.NoDatabaseConnectionException;
import net.lukemurphey.nsia.NotFoundException;
import net.lukemurphey.nsia.NumericalOverflowException;
import net.lukemurphey.nsia.SessionManagement;
import net.lukemurphey.nsia.eventlog.EventLogField;
import net.lukemurphey.nsia.eventlog.EventLogMessage;

public class UserManagement {
    private Application appRes = null;
    public static final String USERNAME_REGEX = "[-A-Z0-9a-z_ .]{0,256}";
    public static final int USERNAME_LENGTH = 32;
    public static final String REALNAME_REGEX = "[-A-Z0-9a-z_ ().]{0,256}";
    public static final int REALNAME_LENGTH = 128;
    private Pattern nameRegex = null;
    private Pattern realNameRegex = null;

    public UserManagement(Application appResources) {
        this.appRes = appResources;
        this.nameRegex = Pattern.compile(USERNAME_REGEX);
        this.realNameRegex = Pattern.compile(REALNAME_REGEX);
    }

    private AccountStatus convertStatusFromInt(int value) {
        AccountStatus[] states = AccountStatus.values();
        int c = 0;
        while (c < states.length) {
            if (states[c].ordinal() == value) {
                return states[c];
            }
            ++c;
        }
        return AccountStatus.DISABLED;
    }

    public UserDescriptor getUserDescriptor(int userId) throws SQLException, NoDatabaseConnectionException, NotFoundException {
        if (userId < 1) {
            throw new IllegalArgumentException("The user ID must be greater than 0");
        }
        Statement statement = null;
        ResultSet result = null;
        Connection connection = null;
        try {
            connection = this.appRes.getDatabaseConnection(Application.DatabaseAccessType.USER_QUERY);
            statement = connection.prepareStatement("Select * from Users where UserID = ?");
            statement.setInt(1, userId);
            result = statement.executeQuery();
            if (result.next()) {
                UserDescriptor userDesc = new UserDescriptor();
                userDesc.userName = result.getString("LoginName");
                userDesc.userId = userId;
                userDesc.localPasswordHash = result.getString("PasswordHash");
                userDesc.localPasswordHashAlgorithm = result.getString("PasswordHashAlgorithm");
                userDesc.hashIterationCount = result.getInt("PasswordHashIterationCount");
                userDesc.accountStatus = this.convertStatusFromInt(result.getInt("AccountStatus"));
                userDesc.salt = result.getString("Salt");
                userDesc.fullname = result.getString("RealName");
                userDesc.unrestricted = result.getBoolean("Unrestricted");
                LocalPasswordAuthentication localAuth = new LocalPasswordAuthentication(Application.getApplication());
                userDesc.bruteForceLocked = localAuth.isAccountBruteForceLocked(userDesc.userName);
                String email = result.getString("EmailAddress");
                if (email != null && email.length() > 0) {
                    try {
                        userDesc.emailAddress = EmailAddress.getByAddress(email);
                    }
                    catch (UnknownHostException e) {
                        this.appRes.logEvent(EventLogMessage.EventType.INTERNAL_ERROR, new EventLogField(EventLogField.FieldName.MESSAGE, "Email address in database for user is invalid: Domain portion of mail address for user '" + userDesc.userName + "'/" + userId + " is invalid (" + email + ")"));
                    }
                    catch (InvalidLocalPartException e) {
                        this.appRes.logEvent(EventLogMessage.EventType.INTERNAL_ERROR, new EventLogField(EventLogField.FieldName.MESSAGE, "Email address in database for user is invalid: Local-part of mail address for user '" + userDesc.userName + "'/" + userId + " is invalid (" + email + ")"));
                    }
                }
                UserDescriptor userDescriptor = userDesc;
                return userDescriptor;
            }
            throw new NotFoundException("No user exists with the given identifier");
        }
        finally {
            if (result != null) {
                result.close();
            }
            if (statement != null) {
                statement.close();
            }
            if (connection != null) {
                connection.close();
            }
        }
    }

    public UserDescriptor[] getUserDescriptors() throws SQLException, NoDatabaseConnectionException {
        Statement statement = null;
        ResultSet result = null;
        Connection connection = null;
        try {
            connection = this.appRes.getDatabaseConnection(Application.DatabaseAccessType.USER_QUERY);
            statement = connection.prepareStatement("Select * from Users");
            result = statement.executeQuery();
            Vector<UserDescriptor> userDescriptors = new Vector<UserDescriptor>();
            while (result.next()) {
                UserDescriptor userDesc = new UserDescriptor();
                userDesc.userName = result.getString("LoginName");
                userDesc.userId = result.getInt("UserID");
                userDesc.localPasswordHash = result.getString("PasswordHash");
                userDesc.localPasswordHashAlgorithm = result.getString("PasswordHashAlgorithm");
                userDesc.hashIterationCount = result.getInt("PasswordHashIterationCount");
                userDesc.accountStatus = this.convertStatusFromInt(result.getInt("AccountStatus"));
                userDesc.salt = result.getString("Salt");
                userDesc.unrestricted = result.getBoolean("Unrestricted");
                userDesc.fullname = result.getString("RealName");
                LocalPasswordAuthentication localAuth = new LocalPasswordAuthentication(Application.getApplication());
                userDesc.bruteForceLocked = localAuth.isAccountBruteForceLocked(userDesc.userName);
                String email = result.getString("EmailAddress");
                if (email != null && email.length() > 0) {
                    try {
                        userDesc.emailAddress = EmailAddress.getByAddress(email);
                    }
                    catch (UnknownHostException e) {
                        this.appRes.logEvent(EventLogMessage.EventType.INTERNAL_ERROR, new EventLogField(EventLogField.FieldName.MESSAGE, "Email address in database for user is invalid: Domain portion of mail address for user '" + userDesc.userName + "'/" + userDesc.userId + " is invalid (" + email + ")"));
                    }
                    catch (InvalidLocalPartException e) {
                        this.appRes.logEvent(EventLogMessage.EventType.INTERNAL_ERROR, new EventLogField(EventLogField.FieldName.MESSAGE, "Email address in database for user is invalid: Local-part of mail address for user '" + userDesc.userName + "'/" + userDesc.userId + " is invalid (" + email + ")"));
                    }
                }
                userDescriptors.add(userDesc);
            }
            UserDescriptor[] userDescriptorsArray = new UserDescriptor[userDescriptors.size()];
            int c = 0;
            while (c < userDescriptors.size()) {
                userDescriptorsArray[c] = (UserDescriptor)userDescriptors.get(c);
                ++c;
            }
            UserDescriptor[] userDescriptorArray = userDescriptorsArray;
            return userDescriptorArray;
        }
        finally {
            if (result != null) {
                result.close();
            }
            if (statement != null) {
                statement.close();
            }
            if (connection != null) {
                connection.close();
            }
        }
    }

    public UserDescriptor getUserDescriptor(String userName) throws SQLException, InputValidationException, NoDatabaseConnectionException, NotFoundException {
        int userId = this.getUserID(userName);
        if (userId < 0) {
            return null;
        }
        return this.getUserDescriptor(userId);
    }

    public int getUserID(String userName) throws SQLException, InputValidationException, NoDatabaseConnectionException {
        if (userName == null || userName.length() == 0) {
            return -1;
        }
        Matcher matcher = this.nameRegex.matcher(userName);
        if (!matcher.matches()) {
            throw new InputValidationException("The username contains invalid characters", "Username", userName);
        }
        if (userName.length() > 32) {
            throw new InputValidationException("The username contains too many characters (" + userName.length() + ")", "Username", userName);
        }
        Statement statement = null;
        ResultSet result = null;
        Connection connection = null;
        try {
            connection = this.appRes.getDatabaseConnection(Application.DatabaseAccessType.USER_QUERY);
            statement = connection.prepareStatement("Select * from Users where Lower(LoginName) = ?");
            statement.setString(1, userName.toLowerCase());
            result = statement.executeQuery();
            if (result.next()) {
                int n = result.getInt("UserID");
                return n;
            }
            return -1;
        }
        finally {
            if (result != null) {
                result.close();
            }
            if (statement != null) {
                statement.close();
            }
            if (connection != null) {
                connection.close();
            }
        }
    }

    public boolean disableAccount(int userId) throws SQLException, NoDatabaseConnectionException, InputValidationException {
        if (userId < 1) {
            throw new IllegalArgumentException("The user ID must be greater than 0");
        }
        Connection conn = this.appRes.getDatabaseConnection(Application.DatabaseAccessType.USER_UPDATE);
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = conn.prepareStatement("Update Users set AccountStatus = ? where UserID = ?");
            preparedStatement.setLong(1, AccountStatus.DISABLED.ordinal());
            preparedStatement.setLong(2, userId);
            if (preparedStatement.executeUpdate() != 1) {
                return false;
            }
            SessionManagement sessionManagement = new SessionManagement(this.appRes);
            sessionManagement.disableUserSessions(userId);
            return true;
        }
        finally {
            if (preparedStatement != null) {
                preparedStatement.close();
            }
            if (conn != null) {
                conn.close();
            }
        }
    }

    public boolean enableAccount(long userId) throws SQLException, NoDatabaseConnectionException, InputValidationException {
        if (userId < 1L) {
            throw new IllegalArgumentException("The user ID must be greater than 0");
        }
        Connection conn = this.appRes.getDatabaseConnection(Application.DatabaseAccessType.USER_UPDATE);
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = conn.prepareStatement("Update Users set AccountStatus = ? where UserID = ?");
            preparedStatement.setLong(1, AccountStatus.VALID_USER.ordinal());
            preparedStatement.setLong(2, userId);
            return preparedStatement.executeUpdate() == 1;
            {
            }
        }
        finally {
            if (preparedStatement != null) {
                preparedStatement.close();
            }
            if (conn != null) {
                conn.close();
            }
        }
    }

    public boolean deleteAccount(int userId) throws SQLException, NoDatabaseConnectionException, InputValidationException {
        if (userId < 1) {
            throw new IllegalArgumentException("The user ID must be greater than 0");
        }
        Connection conn = this.appRes.getDatabaseConnection(Application.DatabaseAccessType.USER_UPDATE);
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = conn.prepareStatement("Delete from Users where UserID = ?");
            preparedStatement.setLong(1, userId);
            if (preparedStatement.executeUpdate() != 1) {
                return false;
            }
            SessionManagement sessionManagement = new SessionManagement(this.appRes);
            sessionManagement.disableUserSessions(userId);
            return true;
        }
        finally {
            if (preparedStatement != null) {
                preparedStatement.close();
            }
            if (conn != null) {
                conn.close();
            }
        }
    }

    public void clearAuthFailedCount(UserDescriptor user) throws SQLException, NumericalOverflowException, InputValidationException, NoDatabaseConnectionException {
        this.clearAuthFailedCount(user.getUserName());
    }

    public void clearAuthFailedCount(String username) throws SQLException, NumericalOverflowException, InputValidationException, NoDatabaseConnectionException {
        LocalPasswordAuthentication localAuth = new LocalPasswordAuthentication(this.appRes);
        localAuth.clearAuthenticationFailedCount(username);
    }

    public synchronized int addAccount(String userName, String realName, String password, EmailAddress emailAddress, boolean unrestricted) throws SQLException, NoSuchAlgorithmException, InputValidationException, NoDatabaseConnectionException {
        String hashAlgorithm = this.appRes.getApplicationConfiguration().getHashAlgorithm();
        long iterationCount = this.appRes.getApplicationConfiguration().getHashIterations();
        return this.addAccount(userName, realName, password, hashAlgorithm, iterationCount, emailAddress, unrestricted);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized int addAccount(String userName, String realName, String password, String hashAlgorithm, long hashIterationCount, EmailAddress emailAddress, boolean unrestricted) throws SQLException, NoSuchAlgorithmException, InputValidationException, NoDatabaseConnectionException {
        if (userName == null) throw new IllegalArgumentException("Username is invalid (null)");
        if (userName.length() == 0) {
            throw new IllegalArgumentException("Username is invalid (null)");
        }
        if (userName.length() == 0) {
            throw new IllegalArgumentException("Username is invalid (empty string)");
        }
        Matcher matcher = this.nameRegex.matcher(userName);
        if (!matcher.matches()) {
            throw new InputValidationException("Username contains invalid characters", "Username", userName);
        }
        if (realName == null) throw new IllegalArgumentException("Real name is invalid (null)");
        if (realName.length() == 0) {
            throw new IllegalArgumentException("Real name is invalid (null)");
        }
        if (realName.length() == 0) {
            throw new IllegalArgumentException("Real name is invalid (empty string)");
        }
        Matcher realNameMatcher = this.realNameRegex.matcher(realName);
        if (!realNameMatcher.matches()) {
            throw new InputValidationException("Real name contains invalid characters", "Realname", realName);
        }
        if (hashAlgorithm == null) {
            throw new IllegalArgumentException("Hash algorithm is invalid (null)");
        }
        if (hashAlgorithm.length() == 0) {
            throw new IllegalArgumentException("Hash algorithm is invalid (empty)");
        }
        if (hashIterationCount < 1L) {
            throw new InputValidationException("Hash iteration count is illegal", "Hash Iteration Count", String.valueOf(hashIterationCount));
        }
        if (this.getUserID(userName) != -1) {
            return -1;
        }
        Timestamp now = new Timestamp(System.currentTimeMillis());
        String salt = LocalPasswordAuthentication.generateSalt(32);
        String passwordHash = LocalPasswordAuthentication.PBKDF2(hashAlgorithm, password, salt, hashIterationCount);
        Connection conn = this.appRes.getDatabaseConnection(Application.DatabaseAccessType.USER_UPDATE);
        PreparedStatement preparedStatement = null;
        ResultSet keys = null;
        try {
            preparedStatement = conn.prepareStatement("Insert into Users (LoginName, PasswordHash, PasswordHashAlgorithm, RealName, AccountStatus, AccountCreated, PasswordLastSet, PasswordHashIterationCount, Salt, EmailAddress, Unrestricted) values (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)", 1);
            preparedStatement.setString(1, userName);
            preparedStatement.setString(2, passwordHash);
            preparedStatement.setString(3, hashAlgorithm);
            preparedStatement.setString(4, realName);
            preparedStatement.setInt(5, AccountStatus.VALID_USER.ordinal());
            preparedStatement.setTimestamp(6, now);
            preparedStatement.setTimestamp(7, now);
            preparedStatement.setLong(8, hashIterationCount);
            preparedStatement.setString(9, salt);
            if (emailAddress == null) {
                preparedStatement.setString(10, "");
            } else {
                preparedStatement.setString(10, emailAddress.toString());
            }
            preparedStatement.setBoolean(11, unrestricted);
            if (preparedStatement.executeUpdate() < 1) {
                return -1;
            }
            keys = preparedStatement.getGeneratedKeys();
            if (!keys.next()) return -1;
            int n = keys.getInt(1);
            return n;
        }
        finally {
            if (preparedStatement != null) {
                preparedStatement.close();
            }
            if (keys != null) {
                keys.close();
            }
            if (conn != null) {
                conn.close();
            }
        }
    }

    public String changePasswordToRandom(int userId, int newPasswordLength) throws NoDatabaseConnectionException, SQLException, InputValidationException, NoSuchAlgorithmException {
        String newPassword = LocalPasswordAuthentication.generateRandomPassword(newPasswordLength);
        if (this.changePassword(userId, newPassword)) {
            return newPassword;
        }
        return null;
    }

    public boolean changePassword(UserDescriptor user, String newPassword) throws NoDatabaseConnectionException, SQLException, InputValidationException, NoSuchAlgorithmException {
        return this.changePassword(user.getUserID(), newPassword);
    }

    public boolean changePassword(int userId, String newPassword) throws NoDatabaseConnectionException, SQLException, InputValidationException, NoSuchAlgorithmException {
        if (newPassword == null) {
            throw new IllegalArgumentException("Password is invalid (null)");
        }
        if (newPassword.length() == 0) {
            throw new IllegalArgumentException("Password is invalid (empty)");
        }
        if (userId < 1) {
            throw new IllegalArgumentException("User ID is invalid (must be greater than 0)");
        }
        Connection conn = this.appRes.getDatabaseConnection(Application.DatabaseAccessType.USER_UPDATE);
        if (conn == null) {
            throw new NoDatabaseConnectionException();
        }
        long hashIterationCount = this.appRes.getApplicationConfiguration().getHashIterations();
        String salt = LocalPasswordAuthentication.generateSalt(32);
        String passwordHashAlgorithm = this.appRes.getApplicationConfiguration().getHashAlgorithm();
        String passwordHash = LocalPasswordAuthentication.PBKDF2(passwordHashAlgorithm, newPassword, salt, hashIterationCount);
        Timestamp now = new Timestamp(System.currentTimeMillis());
        PreparedStatement prepStmt = null;
        try {
            prepStmt = conn.prepareStatement("Update Users set PasswordHash = ?, PasswordHashAlgorithm = ?, PasswordLastSet = ?, Salt = ?, PasswordHashIterationCount = ?  where UserID = ?");
            prepStmt.setString(1, passwordHash);
            prepStmt.setString(2, passwordHashAlgorithm);
            prepStmt.setTimestamp(3, now);
            prepStmt.setString(4, salt);
            prepStmt.setLong(5, hashIterationCount);
            prepStmt.setLong(6, userId);
            return prepStmt.executeUpdate() > 0;
            {
            }
        }
        finally {
            if (prepStmt != null) {
                prepStmt.close();
            }
            if (conn != null) {
                conn.close();
            }
        }
    }

    public boolean updateAccount(int userId, String userName, String realName, EmailAddress emailAddress) throws InputValidationException, SQLException, NoDatabaseConnectionException {
        if (userId < 1) {
            throw new IllegalArgumentException("User ID is invalid (must be greater than 0)");
        }
        if (realName == null || realName.length() == 0) {
            throw new IllegalArgumentException("Real name is invalid (null)");
        }
        if (realName.length() == 0) {
            throw new IllegalArgumentException("Real name is invalid (empty string)");
        }
        Matcher realNameMatcher = this.realNameRegex.matcher(realName);
        if (!realNameMatcher.matches()) {
            throw new InputValidationException("Real name contains invalid characters", "Realname", realName);
        }
        if (userName == null || userName.length() == 0) {
            throw new IllegalArgumentException("User name is invalid (null)");
        }
        if (realName.length() == 0) {
            throw new IllegalArgumentException("User name is invalid (empty string)");
        }
        Matcher userNameMatcher = this.nameRegex.matcher(userName);
        if (!userNameMatcher.matches()) {
            throw new InputValidationException("User name contains invalid characters", "Username", userName);
        }
        Connection conn = this.appRes.getDatabaseConnection(Application.DatabaseAccessType.USER_UPDATE);
        if (conn == null) {
            throw new NoDatabaseConnectionException();
        }
        String emailAddressStr = emailAddress == null ? "" : emailAddress.toString();
        PreparedStatement statement = null;
        try {
            statement = conn.prepareStatement("Update Users set LoginName =?, RealName = ?, EmailAddress = ? where UserID = ?");
            statement.setString(1, userName);
            statement.setString(2, realName);
            statement.setString(3, emailAddressStr);
            statement.setLong(4, userId);
            return statement.executeUpdate() >= 1;
            {
            }
        }
        finally {
            if (statement != null) {
                statement.close();
            }
            if (conn != null) {
                conn.close();
            }
        }
    }

    public boolean updateAccount(int userId, String userName, String realName, EmailAddress emailAddress, boolean accountEnabled) throws InputValidationException, SQLException, NoDatabaseConnectionException {
        if (userId < 1) {
            throw new IllegalArgumentException("User ID is invalid (must be greater than 0)");
        }
        if (realName == null || realName.length() == 0) {
            throw new IllegalArgumentException("Real name is invalid (null)");
        }
        if (realName.length() == 0) {
            throw new IllegalArgumentException("Real name is invalid (empty string)");
        }
        Matcher realNameMatcher = this.realNameRegex.matcher(realName);
        if (!realNameMatcher.matches()) {
            throw new InputValidationException("Real name contains invalid characters", "Realname", realName);
        }
        if (userName == null || userName.length() == 0) {
            throw new IllegalArgumentException("User name is invalid (null)");
        }
        if (realName.length() == 0) {
            throw new IllegalArgumentException("User name is invalid (empty string)");
        }
        Matcher userNameMatcher = this.nameRegex.matcher(userName);
        if (!userNameMatcher.matches()) {
            throw new InputValidationException("User name contains invalid characters", "Username", userName);
        }
        Connection conn = this.appRes.getDatabaseConnection(Application.DatabaseAccessType.USER_UPDATE);
        if (conn == null) {
            throw new NoDatabaseConnectionException();
        }
        String emailAddressStr = emailAddress == null ? "" : emailAddress.toString();
        PreparedStatement statement = null;
        try {
            statement = conn.prepareStatement("Update Users set LoginName =?, RealName = ?, EmailAddress = ?, AccountStatus = ? where UserID = ?");
            statement.setString(1, userName);
            statement.setString(2, realName);
            statement.setString(3, emailAddressStr);
            statement.setLong(5, userId);
            if (!accountEnabled) {
                statement.setLong(4, AccountStatus.DISABLED.ordinal());
            } else {
                statement.setLong(4, AccountStatus.VALID_USER.ordinal());
            }
            return statement.executeUpdate() >= 1;
            {
            }
        }
        finally {
            if (statement != null) {
                statement.close();
            }
            if (conn != null) {
                conn.close();
            }
        }
    }

    public boolean updateAccountEx(int userId, String userName, String realName, EmailAddress emailAddress, boolean unrestricted, boolean accountEnabled) throws InputValidationException, SQLException, NoDatabaseConnectionException {
        if (userId < 1) {
            throw new IllegalArgumentException("User ID is invalid (must be greater than 0)");
        }
        if (realName == null || realName.length() == 0) {
            throw new IllegalArgumentException("Real name is invalid (null)");
        }
        if (realName.length() == 0) {
            throw new IllegalArgumentException("Real name is invalid (empty string)");
        }
        Matcher realNameMatcher = this.realNameRegex.matcher(realName);
        if (!realNameMatcher.matches()) {
            throw new InputValidationException("Real name contains invalid characters", "Realname", realName);
        }
        if (userName == null || userName.length() == 0) {
            throw new IllegalArgumentException("User name is invalid (null)");
        }
        if (realName.length() == 0) {
            throw new IllegalArgumentException("User name is invalid (empty string)");
        }
        Matcher userNameMatcher = this.nameRegex.matcher(userName);
        if (!userNameMatcher.matches()) {
            throw new InputValidationException("User name contains invalid characters", "Username", userName);
        }
        Connection conn = this.appRes.getDatabaseConnection(Application.DatabaseAccessType.USER_UPDATE);
        if (conn == null) {
            throw new NoDatabaseConnectionException();
        }
        String emailAddressStr = emailAddress == null ? "" : emailAddress.toString();
        PreparedStatement statement = null;
        try {
            statement = conn.prepareStatement("Update Users set LoginName =?, RealName = ?, EmailAddress = ?, Unrestricted = ?, AccountStatus = ? where UserID = ?");
            statement.setString(1, userName);
            statement.setString(2, realName);
            statement.setString(3, emailAddressStr);
            statement.setBoolean(4, unrestricted);
            statement.setLong(6, userId);
            if (!accountEnabled) {
                statement.setLong(5, AccountStatus.DISABLED.ordinal());
            } else {
                statement.setLong(5, AccountStatus.VALID_USER.ordinal());
            }
            return statement.executeUpdate() >= 1;
            {
            }
        }
        finally {
            if (statement != null) {
                statement.close();
            }
            if (conn != null) {
                conn.close();
            }
        }
    }

    public boolean updateAccountEx(int userId, String userName, String realName, EmailAddress emailAddress, boolean unrestricted) throws InputValidationException, SQLException, NoDatabaseConnectionException {
        if (userId < 1) {
            throw new IllegalArgumentException("User ID is invalid (must be greater than 0)");
        }
        if (realName == null || realName.length() == 0) {
            throw new IllegalArgumentException("Real name is invalid (null)");
        }
        if (realName.length() == 0) {
            throw new IllegalArgumentException("Real name is invalid (empty string)");
        }
        Matcher realNameMatcher = this.realNameRegex.matcher(realName);
        if (!realNameMatcher.matches()) {
            throw new InputValidationException("Real name contains invalid characters", "Realname", realName);
        }
        if (userName == null || userName.length() == 0) {
            throw new IllegalArgumentException("User name is invalid (null)");
        }
        if (realName.length() == 0) {
            throw new IllegalArgumentException("User name is invalid (empty string)");
        }
        Matcher userNameMatcher = this.nameRegex.matcher(userName);
        if (!userNameMatcher.matches()) {
            throw new InputValidationException("User name contains invalid characters", "Username", userName);
        }
        Connection conn = this.appRes.getDatabaseConnection(Application.DatabaseAccessType.USER_UPDATE);
        if (conn == null) {
            throw new NoDatabaseConnectionException();
        }
        String emailAddressStr = emailAddress == null ? "" : emailAddress.toString();
        PreparedStatement statement = null;
        try {
            statement = conn.prepareStatement("Update Users set LoginName =?, RealName = ?, EmailAddress = ?, Unrestricted = ? where UserID = ?");
            statement.setString(1, userName);
            statement.setString(2, realName);
            statement.setString(3, emailAddressStr);
            statement.setBoolean(4, unrestricted);
            statement.setLong(5, userId);
            return statement.executeUpdate() >= 1;
            {
            }
        }
        finally {
            if (statement != null) {
                statement.close();
            }
            if (conn != null) {
                conn.close();
            }
        }
    }

    public static enum AccountStatus {
        VALID_USER,
        INVALID_USER,
        DISABLED,
        ADMINISTRATIVELY_LOCKED,
        BRUTE_FORCE_LOCKED;

    }

    public static class UserDescriptor {
        private String userName;
        private String localPasswordHash;
        private String localPasswordHashAlgorithm;
        private String salt;
        private int hashIterationCount = -1;
        private int userId = -1;
        private AccountStatus accountStatus = AccountStatus.INVALID_USER;
        private EmailAddress emailAddress;
        private boolean unrestricted = false;
        private String fullname;
        private boolean bruteForceLocked = false;

        public String getUserName() {
            return this.userName;
        }

        public String getPasswordHash() {
            return this.localPasswordHash;
        }

        public String getPasswordHashAlgorithm() {
            return this.localPasswordHashAlgorithm;
        }

        public int getUserID() {
            return this.userId;
        }

        public AccountStatus getAccountStatus() {
            return this.accountStatus;
        }

        public boolean isEnabled() {
            return this.accountStatus != AccountStatus.DISABLED;
        }

        public String getFullname() {
            return this.fullname;
        }

        public int getPasswordHashIterationCount() {
            return this.hashIterationCount;
        }

        public String getPasswordHashSalt() {
            return this.salt;
        }

        public EmailAddress getEmailAddress() {
            return this.emailAddress;
        }

        public boolean isUnrestricted() {
            return this.unrestricted;
        }

        public boolean isBruteForceLocked() {
            return this.bruteForceLocked;
        }

        public String toString() {
            return this.getUserName();
        }
    }
}

