/*
 * Decompiled with CFR 0.152.
 */
package net.lukemurphey.nsia;

import java.io.IOException;
import net.lukemurphey.nsia.Application;
import net.lukemurphey.nsia.ApplicationVersionDescriptor;
import net.lukemurphey.nsia.rest.ApplicationVersionInfo;
import net.lukemurphey.nsia.rest.RESTRequestFailedException;

public class VersionManagement {
    private static ApplicationVersionDescriptor cachedVersionInfo = null;
    private static boolean versionBeingChecked = false;
    private static long versionLastChecked = -1L;

    private static synchronized ApplicationVersionDescriptor getVersionID() throws RESTRequestFailedException, IOException {
        ApplicationVersionInfo appInfo = new ApplicationVersionInfo();
        ApplicationVersionDescriptor result = appInfo.getCurrentApplicationVersion();
        cachedVersionInfo = result != null ? result : null;
        return cachedVersionInfo;
    }

    public static boolean isNewerVersionAvailable(boolean dontBlock) throws RESTRequestFailedException, IOException {
        ApplicationVersionDescriptor latestAvailable = VersionManagement.getNewestVersionAvailableID(dontBlock);
        if (latestAvailable == null) {
            return false;
        }
        ApplicationVersionDescriptor current = new ApplicationVersionDescriptor(Application.getVersion());
        return ApplicationVersionDescriptor.isLaterVersion(current, latestAvailable);
    }

    public static synchronized ApplicationVersionDescriptor getNewestVersionAvailableID(boolean dontBlock) throws RESTRequestFailedException, IOException {
        boolean lastCheckFresh;
        boolean bl = lastCheckFresh = versionLastChecked + 14400000L > System.currentTimeMillis();
        if (lastCheckFresh || dontBlock) {
            if (!lastCheckFresh && !versionBeingChecked) {
                VersionChecker checker = new VersionChecker();
                checker.start();
            }
            return cachedVersionInfo;
        }
        return VersionManagement.getVersionID();
    }

    public static boolean isUpdateAvailable() throws RESTRequestFailedException, IOException {
        ApplicationVersionDescriptor latestAvailable = VersionManagement.getNewestVersionAvailableID(false);
        ApplicationVersionDescriptor current = new ApplicationVersionDescriptor(Application.getVersion());
        if (ApplicationVersionDescriptor.isLaterVersion(current, latestAvailable)) {
            return true;
        }
        return true;
    }

    private static class VersionChecker
    extends Thread {
        public Thread.UncaughtExceptionHandler exHandler = null;

        private VersionChecker() {
        }

        @Override
        public void run() {
            try {
                try {
                    versionBeingChecked = true;
                    versionLastChecked = System.currentTimeMillis();
                    VersionManagement.getVersionID();
                }
                catch (Exception e) {
                    if (this.exHandler != null) {
                        this.exHandler.uncaughtException(this, e);
                    }
                    versionBeingChecked = false;
                }
            }
            finally {
                versionBeingChecked = false;
            }
        }
    }
}

