/*
 * Decompiled with CFR 0.152.
 */
package net.lukemurphey.nsia;

import java.util.regex.Pattern;

public class Wildcard {
    protected Pattern pattern = null;
    protected String wildcard = null;

    public Wildcard(String wildcardPattern) {
        this.wildcard = wildcardPattern;
        this.pattern = Wildcard.compile(wildcardPattern, false);
    }

    public Wildcard(String wildcardPattern, boolean caseInsensitive) {
        this.wildcard = wildcardPattern;
        this.pattern = Wildcard.compile(wildcardPattern, caseInsensitive);
    }

    public String wildcard() {
        return this.wildcard;
    }

    public Pattern getPattern() {
        return this.pattern;
    }

    public String toString() {
        return this.wildcard;
    }

    private static Pattern compile(String wildcard, boolean caseInsensitive) {
        StringBuffer s = new StringBuffer(wildcard.length());
        s.append('^');
        int i = 0;
        int is = wildcard.length();
        while (i < is) {
            char c = wildcard.charAt(i);
            switch (c) {
                case '*': {
                    s.append(".*");
                    break;
                }
                case '?': {
                    s.append(".");
                    break;
                }
                case '$': 
                case '(': 
                case ')': 
                case '.': 
                case '[': 
                case '\\': 
                case ']': 
                case '^': 
                case '{': 
                case '|': 
                case '}': {
                    s.append("\\");
                    s.append(c);
                    break;
                }
                default: {
                    s.append(c);
                }
            }
            ++i;
        }
        s.append('$');
        if (caseInsensitive) {
            return Pattern.compile(s.toString(), 2);
        }
        return Pattern.compile(s.toString());
    }
}

