/*
 * Decompiled with CFR 0.152.
 */
package net.lukemurphey.nsia.console;

import java.sql.SQLException;
import java.util.Vector;
import net.lukemurphey.nsia.Application;
import net.lukemurphey.nsia.InputValidationException;
import net.lukemurphey.nsia.NoDatabaseConnectionException;
import net.lukemurphey.nsia.NotFoundException;
import net.lukemurphey.nsia.console.ConsoleCommand;
import net.lukemurphey.nsia.eventlog.EventLogViewer;
import org.apache.commons.lang.StringUtils;

public class EventLogViewCommand
extends ConsoleCommand {
    public EventLogViewCommand(Application application, String ... names) {
        super("<event log entry ID>", "Opens an event log entry for viewing", application, names);
    }

    @Override
    public ConsoleCommand.CommandResult run(String[] input) throws SQLException, NoDatabaseConnectionException, InputValidationException {
        int entryId;
        if (input.length <= 1) {
            System.out.println("Error: not enough arguments provided, syntax of the command is \" " + this.getSampleInvocation() + "\"");
            return ConsoleCommand.CommandResult.SYNTAX_ERROR;
        }
        if (input.length > 2) {
            System.out.println("Error: too many arguments provided, syntax of the command is \"" + this.getSampleInvocation() + "\"");
            return ConsoleCommand.CommandResult.SYNTAX_ERROR;
        }
        try {
            entryId = Integer.parseInt(input[1]);
        }
        catch (NumberFormatException e) {
            System.out.println("Error: the event log entry ID is not a valid integer");
            return ConsoleCommand.CommandResult.SYNTAX_ERROR;
        }
        Vector<String[]> tableData = new Vector<String[]>();
        EventLogViewer viewer = new EventLogViewer(this.application);
        tableData.add(new String[]{"Log Entry", ""});
        try {
            EventLogViewer.EventLogEntry entry = viewer.getEntry(entryId);
            tableData.add(new String[]{"Severity", entry.getSeverity().toString()});
            tableData.add(new String[]{"Date", entry.getDate().toString()});
            tableData.add(new String[]{"Entry ID", String.valueOf(entryId)});
            tableData.add(new String[]{"Message", entry.getMessage()});
            String[] notes = StringUtils.split((String)entry.getNotes(), (String)",");
            int c = 0;
            while (c < notes.length) {
                boolean isLast = false;
                if (c == notes.length - 1) {
                    isLast = true;
                }
                if (c == 0 && isLast) {
                    tableData.add(new String[]{"Details", notes[c].trim()});
                } else if (c == 0) {
                    tableData.add(new String[]{"Details", String.valueOf(notes[c].trim()) + ","});
                } else if (isLast) {
                    tableData.add(new String[]{"", notes[c].trim()});
                } else {
                    tableData.add(new String[]{"", String.valueOf(notes[c].trim()) + ","});
                }
                ++c;
            }
            System.out.println(EventLogViewCommand.getTableFromString(tableData, true));
        }
        catch (NotFoundException e) {
            System.out.println("No event log entry was found with ID " + entryId);
        }
        return ConsoleCommand.CommandResult.EXECUTED_CORRECTLY;
    }
}

