/*
 * Decompiled with CFR 0.152.
 */
package net.lukemurphey.nsia.console;

import java.sql.SQLException;
import net.lukemurphey.nsia.Application;
import net.lukemurphey.nsia.NoDatabaseConnectionException;
import net.lukemurphey.nsia.UserManagement;
import net.lukemurphey.nsia.console.ConsoleCommand;

public class ListUsersCommand
extends ConsoleCommand {
    public ListUsersCommand(Application application, String ... names) {
        super(null, "Lists user accounts", application, names);
    }

    @Override
    public ConsoleCommand.CommandResult run(String[] input) throws SQLException, NoDatabaseConnectionException {
        UserManagement userManagement = new UserManagement(this.application);
        UserManagement.UserDescriptor[] userDescriptors = userManagement.getUserDescriptors();
        String[][] table = new String[userDescriptors.length + 1][5];
        table[0] = new String[]{"Login Name", "Full Name", "User ID", "Status", "Is Unrestricted"};
        int c = 0;
        while (c < userDescriptors.length) {
            String status = null;
            status = userDescriptors[c].getAccountStatus() == UserManagement.AccountStatus.ADMINISTRATIVELY_LOCKED ? "Administratively Locked" : (userDescriptors[c].getAccountStatus() == UserManagement.AccountStatus.BRUTE_FORCE_LOCKED ? "Locked due to repeated authentication failures" : (userDescriptors[c].getAccountStatus() == UserManagement.AccountStatus.DISABLED ? "Disabled" : "Active"));
            String unrestricted = userDescriptors[c].isUnrestricted() ? "yes" : "no";
            table[c + 1] = new String[]{userDescriptors[c].getUserName(), userDescriptors[c].getFullname(), String.valueOf(userDescriptors[c].getUserID()), status, unrestricted};
            ++c;
        }
        System.out.println(ListUsersCommand.getTableFromString(table, true));
        return ConsoleCommand.CommandResult.EXECUTED_CORRECTLY;
    }
}

