/*
 * Decompiled with CFR 0.152.
 */
package net.lukemurphey.nsia.console;

import java.text.DecimalFormat;
import net.lukemurphey.nsia.Application;
import net.lukemurphey.nsia.console.ConsoleCommand;

public class ShowStatsCommand
extends ConsoleCommand {
    public ShowStatsCommand(Application application, String ... names) {
        super(null, "Displays system statistics (memory used, threads, etc.)", application, names);
    }

    @Override
    public ConsoleCommand.CommandResult run(String[] input) {
        if (input.length > 1) {
            System.out.println("Error: too many arguments provided, syntax of the command is \"" + this.getSampleInvocation() + "\"");
            return ConsoleCommand.CommandResult.ERROR;
        }
        Application.ApplicationStatusDescriptor statusDesc = this.application.getManagerStatus();
        String[][] table = new String[7][2];
        table[0] = new String[]{"System Status:", ""};
        if (statusDesc.getOverallStatus() == 1) {
            table[1] = new String[]{"Overall Status:", "Warning (Yellow), " + statusDesc.getShortDescription()};
        } else if (statusDesc.getOverallStatus() == 2) {
            table[1] = new String[]{"Overall Status:", "Critical (Red), " + statusDesc.getShortDescription()};
        } else if (statusDesc.getOverallStatus() == 0) {
            table[1] = new String[]{"Overall Status:", "Normal (Green), " + statusDesc.getShortDescription()};
        }
        table[2] = new String[]{"Memory Available:", ShowStatsCommand.getBytesDescription(this.application.getMaxMemory())};
        table[3] = new String[]{"Memory Used:", ShowStatsCommand.getBytesDescription(this.application.getUsedMemory())};
        table[4] = new String[]{"Active Database Connections:", String.valueOf(this.application.getDatabaseConnectionCount())};
        table[5] = new String[]{"Uptime:", ShowStatsCommand.getTimeDescription(this.application.getUptime() / 1000L)};
        table[6] = new String[]{"Threads Executing:", String.valueOf(this.application.getThreadCount())};
        System.out.println(ShowStatsCommand.getTableFromString(table, true));
        return ConsoleCommand.CommandResult.EXECUTED_CORRECTLY;
    }

    private static String getBytesDescription(long bytes) {
        double bytesDouble = bytes;
        DecimalFormat twoPlaces = new DecimalFormat("0.00");
        if (bytes < 1024L) {
            return String.valueOf(bytes) + " Bytes";
        }
        if (bytes < 0x100000L) {
            return String.valueOf(twoPlaces.format(bytesDouble / 1024.0)) + " KB";
        }
        if (bytes < 0x40000000L) {
            return String.valueOf(twoPlaces.format(bytesDouble / 1048576.0)) + " MB";
        }
        return String.valueOf(twoPlaces.format(bytesDouble / 1.073741824E9)) + " GB";
    }

    private static String getTimeDescription(long secs) {
        double doubleSecs = secs;
        DecimalFormat twoPlaces = new DecimalFormat("0.00");
        if (secs < 60L) {
            return String.valueOf(secs) + " sec";
        }
        if (secs < 3600L) {
            return String.valueOf(twoPlaces.format(doubleSecs / 60.0)) + " min";
        }
        if (secs < 86400L) {
            return String.valueOf(twoPlaces.format(doubleSecs / 3600.0)) + " hours";
        }
        return String.valueOf(twoPlaces.format(doubleSecs / 86400.0)) + " days";
    }
}

