/*
 * Decompiled with CFR 0.152.
 */
package net.lukemurphey.nsia.console;

import net.lukemurphey.nsia.Application;
import net.lukemurphey.nsia.GenericUtils;
import net.lukemurphey.nsia.console.ConsoleCommand;
import net.lukemurphey.nsia.eventlog.EventLogField;
import net.lukemurphey.nsia.eventlog.EventLogMessage;

public class ShutdownCommand
extends ConsoleCommand {
    public ShutdownCommand(Application application, String ... names) {
        super(null, "Shuts down the application", application, names);
    }

    @Override
    public ConsoleCommand.CommandResult run(String[] input) {
        if (input.length > 1) {
            System.out.println("Error: too many arguments provided, syntax of the command is \"" + this.getSampleInvocation() + "\"");
            return ConsoleCommand.CommandResult.SYNTAX_ERROR;
        }
        this.application.logEvent(EventLogMessage.EventType.APPLICATION_SHUTTING_DOWN, new EventLogField(EventLogField.FieldName.UPTIME, GenericUtils.getTimeDescription(this.application.getUptime() / 1000L)));
        this.application.shutdown(Application.ShutdownRequestSource.CLI, false);
        return ConsoleCommand.CommandResult.TERMINATE_CONSOLE;
    }
}

