/*
 * Decompiled with CFR 0.152.
 */
package net.lukemurphey.nsia.console;

import java.sql.SQLException;
import java.util.Vector;
import net.lukemurphey.nsia.Application;
import net.lukemurphey.nsia.InputValidationException;
import net.lukemurphey.nsia.NoDatabaseConnectionException;
import net.lukemurphey.nsia.WorkerThread;
import net.lukemurphey.nsia.console.ConsoleCommand;

public class TaskListCommand
extends ConsoleCommand {
    public TaskListCommand(Application application, String ... names) {
        super("(all)", "Lists the running tasks", application, names);
    }

    @Override
    public ConsoleCommand.CommandResult run(String[] input) throws SQLException, NoDatabaseConnectionException, InputValidationException {
        if (input.length > 2) {
            System.out.println("Error: too many arguments provided, syntax of the command is \"" + this.getSampleInvocation() + "\"");
            return ConsoleCommand.CommandResult.ERROR;
        }
        Application.WorkerThreadDescriptor[] threads = Application.getApplication().getWorkerThreadQueue();
        Vector<String[]> table = new Vector<String[]>();
        table.add(new String[]{"Task ID", "User ID", "Task Description", "Progress"});
        boolean showAll = false;
        if (input.length == 2) {
            showAll = input[1].equalsIgnoreCase("all");
        }
        int c = 0;
        while (c < threads.length) {
            if (threads[c].getWorkerThread().getStatus() == WorkerThread.State.STOPPED && showAll) {
                table.add(new String[]{threads[c].getUniqueName(), String.valueOf(threads[c].getUserID()), threads[c].getWorkerThread().getTaskDescription(), threads[c].getWorkerThread().getStatusDescription()});
            } else if (threads[c].getWorkerThread().getStatus() != WorkerThread.State.STOPPED) {
                table.add(new String[]{threads[c].getUniqueName(), String.valueOf(threads[c].getUserID()), threads[c].getWorkerThread().getTaskDescription(), threads[c].getWorkerThread().getStatusDescription()});
            }
            ++c;
        }
        String[][] tableArray = new String[table.size()][];
        table.toArray((T[])tableArray);
        System.out.println(TaskListCommand.getTableFromString(tableArray, true));
        if (table.size() == 1) {
            System.out.println("No running tasks\n");
        }
        return ConsoleCommand.CommandResult.ERROR;
    }
}

