/*
 * Decompiled with CFR 0.152.
 */
package net.lukemurphey.nsia.console;

import java.sql.SQLException;
import net.lukemurphey.nsia.Application;
import net.lukemurphey.nsia.InputValidationException;
import net.lukemurphey.nsia.NoDatabaseConnectionException;
import net.lukemurphey.nsia.WorkerThread;
import net.lukemurphey.nsia.console.ConsoleCommand;

public class TaskStopCommand
extends ConsoleCommand {
    public TaskStopCommand(Application application, String ... names) {
        super("<task ID>", "Stops running background tasks", application, names);
    }

    @Override
    public ConsoleCommand.CommandResult run(String[] input) throws SQLException, NoDatabaseConnectionException, InputValidationException {
        Application.WorkerThreadDescriptor[] threadQueue;
        if (input.length < 2) {
            System.out.println("Error: not enough arguments provided, syntax of the command is \"" + this.getSampleInvocation() + "\"");
            return ConsoleCommand.CommandResult.SYNTAX_ERROR;
        }
        if (input.length > 2) {
            System.out.println("Error: too many arguments provided, syntax of the command is \"" + this.getSampleInvocation() + "\"");
            return ConsoleCommand.CommandResult.SYNTAX_ERROR;
        }
        String taskToStop = input[1];
        Application.WorkerThreadDescriptor[] workerThreadDescriptorArray = threadQueue = this.application.getWorkerThreadQueue(true);
        int n = threadQueue.length;
        int n2 = 0;
        while (n2 < n) {
            Application.WorkerThreadDescriptor thread = workerThreadDescriptorArray[n2];
            if (thread.getUniqueName().equalsIgnoreCase(taskToStop)) {
                thread.getWorkerThread().terminate();
                System.out.print("Stopping task...");
                int c = 0;
                while (c < 4) {
                    block8: {
                        try {
                            if (thread.getWorkerThread().getStatus() != WorkerThread.State.STOPPED) {
                                Thread.sleep(1000L);
                                break block8;
                            }
                            System.out.println("done");
                            return ConsoleCommand.CommandResult.EXECUTED_CORRECTLY;
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                    ++c;
                }
                System.out.println("(backgrounding)");
                return ConsoleCommand.CommandResult.EXECUTED_CORRECTLY;
            }
            ++n2;
        }
        System.out.println("No task found with the given identifier");
        return ConsoleCommand.CommandResult.EXECUTED_CORRECTLY;
    }
}

