/*
 * Decompiled with CFR 0.152.
 */
package net.lukemurphey.nsia.eventlog;

import net.lukemurphey.nsia.Application;
import net.lukemurphey.nsia.eventlog.CommonEventExpressionMessage;
import net.lukemurphey.nsia.eventlog.EventLogField;
import net.lukemurphey.nsia.eventlog.EventLogMessage;
import net.lukemurphey.nsia.eventlog.MessageFormatter;

public class CommonEventExpressionMessageFormatter
extends MessageFormatter {
    @Override
    public String formatMessage(EventLogMessage message) {
        CommonEventExpressionMessage cee = new CommonEventExpressionMessage();
        EventLogField[] fields = message.getFields();
        cee.addExtensionField(new CommonEventExpressionMessage.ExtensionField(CommonEventExpressionMessage.CommonEventExpressionField.VENDOR, "ThreatFactor"));
        cee.addExtensionField(new CommonEventExpressionMessage.ExtensionField(CommonEventExpressionMessage.CommonEventExpressionField.PRODUCT, "NSIA"));
        cee.addExtensionField(new CommonEventExpressionMessage.ExtensionField(CommonEventExpressionMessage.CommonEventExpressionField.PRODUCT_VERSION, Application.getVersion()));
        cee.addExtensionField(new CommonEventExpressionMessage.ExtensionField(CommonEventExpressionMessage.CommonEventExpressionField.EVENT_ID, Integer.toString(message.getEventType().ordinal())));
        cee.addExtensionField(new CommonEventExpressionMessage.ExtensionField("event", message.getEventType().getName()));
        cee.addExtensionField(new CommonEventExpressionMessage.ExtensionField(CommonEventExpressionMessage.CommonEventExpressionField.SYSLOG_PRIORITY, String.valueOf(message.getEventType().getSeverity().getSyslogEquivalent())));
        cee.addExtensionField(new CommonEventExpressionMessage.ExtensionField(EventLogField.FieldName.SEVERITY.getSimpleNameFormat(), String.valueOf(message.getEventType().getSeverity().toString())));
        int c = 0;
        while (c < fields.length) {
            if (fields[c].getName() == EventLogField.FieldName.SOURCE_USER_ID) {
                cee.addExtensionField(new CommonEventExpressionMessage.ExtensionField(CommonEventExpressionMessage.CommonEventExpressionField.SRC_USER_ID, fields[c].getValue()));
            } else if (fields[c].getName() == EventLogField.FieldName.SOURCE_USER_NAME) {
                cee.addExtensionField(new CommonEventExpressionMessage.ExtensionField(CommonEventExpressionMessage.CommonEventExpressionField.SRC_USER, fields[c].getValue()));
            } else if (fields[c].getName() == EventLogField.FieldName.TARGET_USER_NAME) {
                cee.addExtensionField(new CommonEventExpressionMessage.ExtensionField(CommonEventExpressionMessage.CommonEventExpressionField.USER, fields[c].getValue()));
            } else if (fields[c].getName() == EventLogField.FieldName.TARGET_USER_ID) {
                cee.addExtensionField(new CommonEventExpressionMessage.ExtensionField(CommonEventExpressionMessage.CommonEventExpressionField.USER_ID, fields[c].getValue()));
            } else if (fields[c].getName() == EventLogField.FieldName.GROUP_ID) {
                cee.addExtensionField(new CommonEventExpressionMessage.ExtensionField(CommonEventExpressionMessage.CommonEventExpressionField.USER_GROUP_ID, fields[c].getValue()));
            } else if (fields[c].getName() == EventLogField.FieldName.GROUP_NAME) {
                cee.addExtensionField(new CommonEventExpressionMessage.ExtensionField(CommonEventExpressionMessage.CommonEventExpressionField.USER_GROUP, fields[c].getValue()));
            } else if (fields[c].getName() == EventLogField.FieldName.SOURCE_ADDRESS) {
                cee.addExtensionField(new CommonEventExpressionMessage.ExtensionField(CommonEventExpressionMessage.CommonEventExpressionField.SRC_HOST, fields[c].getValue()));
            } else if (fields[c].getName() == EventLogField.FieldName.URL) {
                cee.addExtensionField(new CommonEventExpressionMessage.ExtensionField(CommonEventExpressionMessage.CommonEventExpressionField.URL, fields[c].getValue()));
            } else if (fields[c].getName() == EventLogField.FieldName.FILE) {
                cee.addExtensionField(new CommonEventExpressionMessage.ExtensionField(CommonEventExpressionMessage.CommonEventExpressionField.FILE_NAME, fields[c].getValue()));
            } else {
                cee.addExtensionField(new CommonEventExpressionMessage.ExtensionField(fields[c].getName().getSimpleNameFormat(), fields[c].getValue()));
            }
            ++c;
        }
        return cee.getCEEMessage();
    }

    @Override
    public String getDescription() {
        return "Common Event Expression";
    }
}

