/*
 * Decompiled with CFR 0.152.
 */
package net.lukemurphey.nsia.eventlog;

import java.util.Vector;
import net.lukemurphey.nsia.eventlog.EventLogField;
import org.apache.commons.lang.StringUtils;

public class CommonEventFormatMessage {
    public static final int VERSION = 0;
    private static final String DELIMINATOR = "|";
    private String deviceVendor = null;
    private String deviceProduct = null;
    private String deviceVersion = null;
    private String deviceSignatureID = null;
    private String name = null;
    private int deviceSeverity = 0;
    Vector<ExtensionField> extensionFields = new Vector();

    public CommonEventFormatMessage(String deviceVendor, String deviceProduct, String deviceVersion, Vector<EventLogField> fields) {
        EventLogField[] fieldsArray = new EventLogField[fields.size()];
        fields.toArray(fieldsArray);
        this.initialize(deviceVendor, deviceProduct, deviceVersion, fieldsArray);
    }

    public CommonEventFormatMessage(String deviceVendor, String deviceProduct, String deviceVersion, EventLogField[] fields) {
        this.initialize(deviceVendor, deviceProduct, deviceVersion, fields);
    }

    public CommonEventFormatMessage(String deviceVendor, String deviceProduct, String deviceVersion, String signatureID, String name, int deviceSeverity) {
        if (deviceVendor == null || deviceVendor.length() == 0) {
            throw new IllegalArgumentException("The device vendor field is required and cannot be null or blank");
        }
        if (deviceProduct == null || deviceProduct.length() == 0) {
            throw new IllegalArgumentException("The device product field is required and cannot be null or blank");
        }
        if (deviceVersion == null || deviceVersion.length() == 0) {
            throw new IllegalArgumentException("The device version field is required and cannot be null or blank");
        }
        if (signatureID == null || signatureID.length() == 0) {
            throw new IllegalArgumentException("The signature ID field is required and cannot be null or blank");
        }
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException("The name field is required and cannot be null or blank");
        }
        if (deviceSeverity < 0 || deviceSeverity > 10) {
            throw new IllegalArgumentException("The severity field is out of range (must not be less than 0 or greater than 10)");
        }
        this.deviceVendor = CommonEventFormatMessage.escapeField(deviceVendor, true);
        this.deviceProduct = CommonEventFormatMessage.escapeField(deviceProduct, true);
        this.deviceVersion = CommonEventFormatMessage.escapeField(deviceVersion, true);
        this.deviceSignatureID = CommonEventFormatMessage.escapeField(signatureID, true);
        this.name = CommonEventFormatMessage.escapeField(name, true);
        this.deviceSeverity = deviceSeverity;
    }

    private void initialize(String deviceVendor, String deviceProduct, String deviceVersion, EventLogField[] fields) {
        this.deviceVendor = CommonEventFormatMessage.escapeField(deviceVendor, true);
        this.deviceProduct = CommonEventFormatMessage.escapeField(deviceProduct, true);
        this.deviceVersion = CommonEventFormatMessage.escapeField(deviceVersion, true);
        int c = 0;
        while (c < fields.length) {
            if (fields[c].getName() == EventLogField.FieldName.TARGET_USER_NAME) {
                this.addExtensionField(new ExtensionField(CommonExtensionDictionaryField.DESTINATION_USER_NAME, fields[c].getValue()));
            } else if (fields[c].getName() == EventLogField.FieldName.TARGET_USER_ID) {
                this.addExtensionField(new ExtensionField(CommonExtensionDictionaryField.DESTINATION_USER_ID, fields[c].getValue()));
            } else if (fields[c].getName() == EventLogField.FieldName.SOURCE_USER_ID) {
                this.addExtensionField(new ExtensionField(CommonExtensionDictionaryField.SOURCE_USER_ID, fields[c].getValue()));
            } else if (fields[c].getName() == EventLogField.FieldName.SOURCE_USER_NAME) {
                this.addExtensionField(new ExtensionField(CommonExtensionDictionaryField.SOURCE_USER, fields[c].getValue()));
            } else if (fields[c].getName() == EventLogField.FieldName.MESSAGE) {
                this.addExtensionField(new ExtensionField(CommonExtensionDictionaryField.MESSAGE, fields[c].getValue()));
            } else if (fields[c].getName() != EventLogField.FieldName.SEVERITY) {
                this.addExtensionField(new ExtensionField(fields[c].getName().getSimpleNameFormat(), fields[c].getValue()));
            }
            ++c;
        }
    }

    public String getDeviceVendor() {
        return this.deviceVendor;
    }

    public String getDeviceProduct() {
        return this.deviceProduct;
    }

    public String getDeviceVersion() {
        return this.deviceVersion;
    }

    public String getDeviceSignatureID() {
        return this.deviceSignatureID;
    }

    public String getName() {
        return this.name;
    }

    public int getSeverity() {
        return this.deviceSeverity;
    }

    public void addExtensionField(ExtensionField field) {
        if (field == null) {
            throw new IllegalArgumentException("The extension field cannot be null");
        }
        this.extensionFields.add(field);
    }

    public ExtensionField[] getExtensionFields() {
        ExtensionField[] fields = new ExtensionField[this.extensionFields.size()];
        this.extensionFields.toArray(fields);
        return fields;
    }

    public static String escapeField(String field, boolean isPrefix) {
        String tempString = null;
        tempString = isPrefix ? StringUtils.replace((String)field, (String)"\\", (String)"\\\\") : StringUtils.replace((String)field, (String)"=", (String)"\\=");
        if (isPrefix) {
            tempString = StringUtils.replace((String)field, (String)DELIMINATOR, (String)"\\|");
        }
        return tempString;
    }

    public String getCEFMessage() {
        StringBuffer message = new StringBuffer();
        message.append("CEF:");
        message.append(0);
        message.append(DELIMINATOR);
        message.append(this.deviceVendor);
        message.append(DELIMINATOR);
        message.append(this.deviceProduct);
        message.append(DELIMINATOR);
        message.append(this.deviceVersion);
        message.append(DELIMINATOR);
        message.append(this.deviceSignatureID);
        message.append(DELIMINATOR);
        message.append(this.name);
        message.append(DELIMINATOR);
        message.append(this.deviceSeverity);
        if (this.extensionFields.size() > 0) {
            message.append(DELIMINATOR);
        }
        boolean isFirst = true;
        for (ExtensionField extensionField : this.extensionFields) {
            if (!isFirst) {
                message.append(" ");
            } else {
                isFirst = false;
            }
            message.append(extensionField.toString());
        }
        return message.toString();
    }

    public String toString() {
        return this.getCEFMessage();
    }

    public static enum CommonExtensionDictionaryField {
        DEVICE_ACTION("act", "deviceAction"),
        APPLICATION_PROTOCOL("app", "applicationProtocol"),
        BYTES_IN("in", "bytesIn"),
        BYTES_OUT("out", "bytesOut"),
        DESTINATION_ADDRESS("dst", "destinationAddress"),
        DESTINATION_HOST_NAME("dhost", "destinationHostName"),
        DESTINATION_MAC_ADDRESS("dmac", "destinationMacAddress"),
        DESTINATION_NT_DOMAIN("dntdom", "destinationNtDomain"),
        DESTINATION_PORT("dpt", "destinationPort"),
        DESTINATION_PROCESS_NAME("dproc", "destinationProcessName"),
        DESTINATION_USER_ID("duid", "destinationUserId"),
        DESTINATION_USER_PRIVILEGES("dpriv", "destinationUserPrivileges"),
        DESTINATION_USER_NAME("duser", "destinationUserName"),
        END_TIME("end", "endTime"),
        FILE_NAME("fname", "fileName"),
        FILE_SIZE("fsize", "fileSize"),
        MESSAGE("msg", "message"),
        RECEIPT_TIME("rt", "receiptTime"),
        REQUEST("request", "requestUrl"),
        SOURCE_ADDRESS("src", "sourceAddress"),
        SOURCE_HOST_NAME("shost", "sourceHostName"),
        SOURCE_MAC_ADDRESS("smac", "sourceMacAddress"),
        SOURCE_NT_DOMAIN("sntdom", "sourceNtDomain"),
        SOURCE_PORT("spt", "sourcePort"),
        SOURCE_USER_ID("suid", "sourceUserId"),
        SOURCE_USER_PRIVILEGES("spriv", "sourceUserPrivileges"),
        SOURCE_USER("suser", "sourceUserName"),
        START_TIME("start", "startTime"),
        TRANSPORT_PROTOCOL("proto", "transportProtocol");

        private final String name;
        private final String desc;

        private CommonExtensionDictionaryField(String name, String desc) {
            this.name = name;
            this.desc = desc;
        }

        public String toString() {
            return this.name;
        }

        public String getName() {
            return this.name;
        }

        public String getFullName() {
            return this.desc;
        }
    }

    public static class ExtensionField {
        private String name;
        private String value = null;

        public ExtensionField(CommonExtensionDictionaryField cedField, String value) {
            this.name = cedField.getName();
            this.value = String.valueOf(value);
        }

        public ExtensionField(String name, String value) {
            this.name = name;
            this.value = String.valueOf(value);
        }

        public ExtensionField(String name, long value) {
            this.name = name;
            this.value = String.valueOf(value);
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(CommonEventFormatMessage.escapeField(this.name, false)) + "=" + CommonEventFormatMessage.escapeField(this.value, false);
        }
    }
}

