/*
 * Decompiled with CFR 0.152.
 */
package net.lukemurphey.nsia.eventlog;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidClassException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import net.lukemurphey.nsia.Application;
import net.lukemurphey.nsia.NoDatabaseConnectionException;
import net.lukemurphey.nsia.eventlog.EventLogField;
import net.lukemurphey.nsia.eventlog.EventLogHookException;
import net.lukemurphey.nsia.eventlog.EventLogMessage;
import net.lukemurphey.nsia.response.Action;
import net.lukemurphey.nsia.response.ActionFailedException;

public abstract class EventLogHook
implements Serializable {
    private static final long serialVersionUID = -3742174021147412985L;
    protected int eventlogHookID = -1;
    protected int actionID = -1;

    public abstract void processEvent(EventLogMessage var1) throws EventLogHookException, ActionFailedException;

    public abstract Action getAction();

    public int getEventLogHookID() {
        return this.eventlogHookID;
    }

    public static EventLogHook loadFromDatabase(Connection connection, int eventlogHookID) throws SQLException {
        if (connection == null) {
            throw new IllegalArgumentException("The database connection cannot be null");
        }
        PreparedStatement statement = null;
        ResultSet result = null;
        try {
            statement = connection.prepareStatement("Select * from EventLogHook where EventLogHookID = ?");
            statement.setInt(1, eventlogHookID);
            result = statement.executeQuery();
            if (result.next()) {
                EventLogHook eventlogHook;
                EventLogHook eventLogHook = eventlogHook = EventLogHook.loadFromDatabase(result);
                return eventLogHook;
            }
        }
        finally {
            if (statement != null) {
                statement.close();
            }
            if (result != null) {
                result.close();
            }
        }
        return null;
    }

    protected static EventLogHook loadFromDatabase(ResultSet result) throws SQLException {
        EventLogMessage message;
        Blob bytes;
        int actionID;
        int hookID;
        block7: {
            if (result == null) {
                throw new IllegalArgumentException("The result set to load from cannot be null");
            }
            hookID = -1;
            hookID = result.getInt("EventLogHookID");
            actionID = result.getInt("ActionID");
            bytes = result.getBlob("State");
            if (bytes != null) break block7;
            return null;
        }
        try {
            InputStream byteInStream = bytes.getBinaryStream();
            ObjectInputStream inStream = new ObjectInputStream(byteInStream);
            try {
                EventLogHook eventlogHook = (EventLogHook)inStream.readObject();
                eventlogHook.eventlogHookID = hookID;
                eventlogHook.actionID = actionID;
                return eventlogHook;
            }
            catch (InvalidClassException e) {
                EventLogMessage message2 = new EventLogMessage(EventLogMessage.EventType.INTERNAL_ERROR);
                message2.addField(new EventLogField(EventLogField.FieldName.MESSAGE, "Unable to load the event log hook for ID \"" + hookID + "\""));
                Application.getApplication().logExceptionEvent(message2, (Throwable)e);
            }
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            message = new EventLogMessage(EventLogMessage.EventType.INTERNAL_ERROR);
            message.addField(new EventLogField(EventLogField.FieldName.MESSAGE, "Unable to instantiate the event log hook for ID \"" + hookID + "\""));
            Application.getApplication().logExceptionEvent(message, (Throwable)e);
        }
        catch (IOException e) {
            e.printStackTrace();
            message = new EventLogMessage(EventLogMessage.EventType.INTERNAL_ERROR);
            message.addField(new EventLogField(EventLogField.FieldName.MESSAGE, "Unable to instantiate the event log hook for ID \"" + hookID + "\""));
            Application.getApplication().logExceptionEvent(message, (Throwable)e);
        }
        return null;
    }

    public void delete() throws SQLException, NoDatabaseConnectionException {
        EventLogHook.delete(this.eventlogHookID);
    }

    public static void delete(long hookID) throws SQLException, NoDatabaseConnectionException {
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        ResultSet result = null;
        SQLException initCause = null;
        long actionID = -1L;
        try {
            try {
                connection = Application.getApplication().getDatabaseConnection(Application.DatabaseAccessType.ACTION);
                preparedStatement = connection.prepareStatement("Select ActionID from EventLogHook where EventLogHookID = ?");
                preparedStatement.setLong(1, hookID);
                result = preparedStatement.executeQuery();
                if (result.next()) {
                    actionID = result.getLong("ActionID");
                }
                result.close();
                preparedStatement.close();
                if (actionID >= 0L) {
                    preparedStatement = connection.prepareStatement("Delete from Action where ActionID = ?");
                    preparedStatement.setLong(1, actionID);
                    preparedStatement.executeUpdate();
                    preparedStatement.close();
                    preparedStatement = null;
                }
                preparedStatement = connection.prepareStatement("Delete from EventLogHook where EventLogHookID = ?");
                preparedStatement.setLong(1, hookID);
                preparedStatement.executeUpdate();
            }
            catch (SQLException e) {
                initCause = e;
                try {
                    if (result != null) {
                        result.close();
                    }
                    if (preparedStatement != null) {
                        preparedStatement.close();
                    }
                    if (connection != null) {
                        connection.close();
                    }
                }
                catch (SQLException e2) {
                    if (initCause != null && e2.getCause() != null) {
                        e2.initCause(initCause);
                        throw e2;
                    }
                    throw e2;
                }
            }
        }
        finally {
            try {
                if (result != null) {
                    result.close();
                }
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException e) {
                if (initCause != null && e.getCause() != null) {
                    e.initCause(initCause);
                    throw e;
                }
                throw e;
            }
        }
    }

    protected void logActionCompletion(Action action) {
        this.logActionCompletion(action, new EventLogField[]{null});
    }

    protected void logActionCompletion(Action action, EventLogField ... extraFields) {
        EventLogMessage eventLogMessage = new EventLogMessage(EventLogMessage.EventType.RESPONSE_ACTION_TRIGGERED, new EventLogField(EventLogField.FieldName.RESPONSE_ACTION_DESC, action.getConfigDescription()), new EventLogField(EventLogField.FieldName.RESPONSE_ACTION_ID, this.getEventLogHookID()), new EventLogField(EventLogField.FieldName.RESPONSE_ACTION_NAME, action.getDescription()));
        if (extraFields != null) {
            EventLogField[] eventLogFieldArray = extraFields;
            int n = extraFields.length;
            int n2 = 0;
            while (n2 < n) {
                EventLogField extraField = eventLogFieldArray[n2];
                eventLogMessage.addField(extraField);
                ++n2;
            }
        }
        Application.getApplication().logEvent(eventLogMessage);
    }

    public void saveToDatabase() throws SQLException, IOException, NoDatabaseConnectionException {
        byte[] bytes = null;
        ByteArrayOutputStream byteOutStream = null;
        ObjectOutputStream outStream = null;
        IOException cause = null;
        try {
            try {
                byteOutStream = new ByteArrayOutputStream();
                outStream = new ObjectOutputStream(byteOutStream);
                outStream.writeObject(this);
                bytes = byteOutStream.toByteArray();
            }
            catch (IOException e) {
                cause = e;
                throw e;
            }
        }
        finally {
            try {
                if (byteOutStream != null) {
                    byteOutStream.close();
                }
                if (outStream != null) {
                    outStream.close();
                }
            }
            catch (IOException e) {
                if (e.getCause() == null) {
                    e.initCause(cause);
                    throw e;
                }
                if (cause != null) {
                    throw cause;
                }
                throw e;
            }
        }
        Connection connection = null;
        Statement statement = null;
        ResultSet keys = null;
        try {
            connection = Application.getApplication().getDatabaseConnection(Application.DatabaseAccessType.ACTION);
            if (this.eventlogHookID >= 0) {
                statement = connection.prepareStatement("Update EventLogHook set State = ? where EventLogHookID = ?");
                statement.setBytes(1, bytes);
                statement.setInt(2, this.eventlogHookID);
                statement.executeUpdate();
            } else {
                statement = connection.prepareStatement("Insert into EventLogHook (State, ActionID) values (?, ?)", 1);
                statement.setBytes(1, bytes);
                Action action = this.getAction();
                if (action.getActionID() < 0) {
                    action.save();
                }
                statement.setInt(2, action.getActionID());
                statement.executeUpdate();
                keys = statement.getGeneratedKeys();
                if (keys.next()) {
                    this.eventlogHookID = keys.getInt(1);
                }
            }
        }
        finally {
            if (connection != null) {
                connection.close();
            }
            if (statement != null) {
                statement.close();
            }
            if (keys != null) {
                keys.close();
            }
        }
    }
}

