/*
 * Decompiled with CFR 0.152.
 */
package net.lukemurphey.nsia.eventlog;

import java.util.Vector;
import net.lukemurphey.nsia.Application;
import net.lukemurphey.nsia.eventlog.EventLogField;
import net.lukemurphey.nsia.eventlog.EventLogHook;
import net.lukemurphey.nsia.eventlog.EventLogHookException;
import net.lukemurphey.nsia.eventlog.EventLogMessage;
import net.lukemurphey.nsia.eventlog.EventLogSeverity;
import net.lukemurphey.nsia.response.Action;
import net.lukemurphey.nsia.response.ActionFailedException;

public class RuleStatusEventLogHook
extends EventLogHook {
    private static final long serialVersionUID = 1L;
    private Action action;
    private String ruleIDString;
    private long ruleID;
    private EventLogSeverity minimumSeverity;

    public RuleStatusEventLogHook(Action action, long ruleID, EventLogSeverity minimumSeverity) {
        if (action == null) {
            throw new IllegalArgumentException("The action to perform cannot be null");
        }
        if (minimumSeverity == null) {
            throw new IllegalArgumentException("The minimum severity level cannot be null");
        }
        if (ruleID < 0L) {
            throw new IllegalArgumentException("The identifier of the scan rule must be greater than zero");
        }
        this.action = action;
        this.minimumSeverity = minimumSeverity;
        this.ruleIDString = Long.toString(ruleID);
        this.ruleID = ruleID;
    }

    public long getRuleID() {
        return this.ruleID;
    }

    @Override
    public void processEvent(EventLogMessage message) throws EventLogHookException {
        if (message == null) {
            return;
        }
        if (message.getSeverity().toInt() < this.minimumSeverity.toInt()) {
            return;
        }
        try {
            EventLogField field;
            if ((message.getEventType() == EventLogMessage.EventType.RULE_REJECTED || message.getEventType() == EventLogMessage.EventType.RULE_FAILED) && (field = message.getField(EventLogField.FieldName.RULE_ID)) != null && field.getValue().equals(this.ruleIDString)) {
                this.action.execute(message);
            }
        }
        catch (ActionFailedException e) {
            throw new EventLogHookException(e);
        }
    }

    @Override
    public Action getAction() {
        return this.action;
    }

    public static RuleStatusEventLogHook[] getRuleStatusEventLogHooks(Application app, long ruleID) {
        EventLogHook[] allHooks = app.getEventLog().getHooks();
        Vector<RuleStatusEventLogHook> ruleHooks = new Vector<RuleStatusEventLogHook>();
        int c = 0;
        while (c < allHooks.length) {
            if (allHooks[c] instanceof RuleStatusEventLogHook && ((RuleStatusEventLogHook)allHooks[c]).getRuleID() == ruleID) {
                ruleHooks.add((RuleStatusEventLogHook)allHooks[c]);
            }
            ++c;
        }
        RuleStatusEventLogHook[] hooksArray = new RuleStatusEventLogHook[ruleHooks.size()];
        ruleHooks.toArray(hooksArray);
        return hooksArray;
    }
}

